/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "widgets/disc-progress.h"

#include "cstr-intl.h"

#include <gtkmm/box.h>
#include <gtkmm/image.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/stock.h>

namespace Coaster
{

namespace Widgets
{

DiscProgress::DiscProgress()
: Gtk::EventBox(),
  m_pHBox(0), m_pWarning(0), m_pProgress(0),
  m_bWarningShown(false)
{
  m_Tooltips.enable();

  m_pHBox = new Gtk::HBox(false, 6);
  add(*manage(m_pHBox));

  m_pWarning = new Gtk::Image();
  m_pHBox->pack_end(*manage(m_pWarning), Gtk::PACK_SHRINK);

  m_pProgress = new Gtk::ProgressBar();
  m_pHBox->pack_end(*manage(m_pProgress), Gtk::PACK_SHRINK);
}

DiscProgress::~DiscProgress()
{}

void DiscProgress::set_fraction(double fraction)
{
  if(fraction > 1.0)
  {
    if(!m_bWarningShown)
      show_warning();

    m_pProgress->set_fraction(1.0);
  }
  else
  {
    if(m_bWarningShown)
      show_warning(false);

    m_pProgress->set_fraction(fraction);
  }
}

void DiscProgress::set_text(const Glib::ustring& text)
{
  m_pProgress->set_text(text);
}

void DiscProgress::show_warning(bool show)
{
  if(show)
  {
    m_bWarningShown = true;
    m_pWarning->set(Gtk::Stock::DIALOG_WARNING, Gtk::ICON_SIZE_MENU);
    m_Tooltips.set_tip(*this, _("Too many files in this layout.  Either change the disc size or remove some files."));
  }
  else
  {
    m_bWarningShown = false;
    m_pWarning->clear();
    m_Tooltips.unset_tip(*this);
  }
}

} // namespace Widgets

} // namespace Coaster
