/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_DISC_INFO_H_
#define _COASTER_DISC_INFO_H_

#include <gtkmm/box.h>

#include "cstr-enums.h"

namespace Gtk
{
class Label;
class ComboBoxText;
}

namespace Coaster
{

namespace Widgets
{

class ComboDiscSize;
class DiscProgress;

class DiscInfo_Base : public Gtk::HBox
{
public:
  virtual ~DiscInfo_Base();

  DiscSizeType get_disc_size() const;

protected:
  DiscInfo_Base();

  Gtk::Label *m_pProgLabel;
  Gtk::Label *m_pComboLabel;
  DiscProgress  *m_pProgress;
  ComboDiscSize *m_pComboBox;
};

} // namespace Widgets

} // namespace Coaster

#endif // _COASTER_DISC_INFO_H_
