/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_COMBO_HISTORY_H_
#define _COASTER_COMBO_HISTORY_H_

#include <gtkmm/comboboxentrytext.h>

#include <gconfmm/entry.h>
#include <deque>

namespace Gnome
{

namespace Conf
{
class Client;
} // namespace Conf

namespace Glade
{
class Xml;
} // namespace Glade

} // namespace Gnome

namespace Coaster
{

namespace Widgets
{

class ComboHistory : public Gtk::ComboBoxEntryText
{
public:
  ComboHistory(BaseObjectType* cobject,
               const Glib::RefPtr<Gnome::Glade::Xml>& refXml);
  virtual ~ComboHistory();

  void grab_focus();
  void set_entry_text(const Glib::ustring& text);
  Glib::ustring get_entry_text() const;

  void prepend_history(const Glib::ustring& text);
  void append_history(const Glib::ustring& text);

protected:
  void on_history_changed(guint cnxn,
                          Gnome::Conf::Entry entry);
  void on_entry_activated();
  void on_entry_changed();

  void add_history(const Glib::ustring& text,
                   bool append);
  void load_history();
  void clear_history();
  void save_history();
  void set_history_items();
  bool has_value(const Glib::ustring& string);


private:
  Glib::RefPtr<Gnome::Conf::Client> m_refClient;
  
  unsigned int m_max_saved;
  guint notify_cnxn;
  bool m_bSaving_history;
  bool m_bChanged;
  
  std::deque<Glib::ustring> m_values;
  Glib::ustring m_entry_text;
};

} // namespace Widgets

} // namespace Coaster

#endif // _COASTER__H_
