/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_COMBO_DISC_SIZE_H_
#define _COASTER_COMBO_DISC_SIZE_H_

#include <gtkmm/combobox.h>
#include <gtkmm/treemodel.h>

#include <libgnomevfsmm/types.h>
#include "cstr-enums.h"

namespace Gtk
{
class ListStore;
} // namespace Gtk

namespace Gnome
{
namespace Glade
{
class Xml;
} // namespace Glade
} // namespace Gnome

namespace Coaster
{

namespace Widgets
{

class ComboDiscSize : public Gtk::ComboBox
{
public:
  ComboDiscSize();
  explicit ComboDiscSize(BaseObjectType* cobject,
                         const Glib::RefPtr<Gnome::Glade::Xml>& refXml);
  virtual ~ComboDiscSize();

  class ComboColumns : public Gtk::TreeModel::ColumnRecord
  {
  public:
    ComboColumns()
    {
      add(m_col_name);
      add(m_col_size);
    }

    Gtk::TreeModelColumn<Glib::ustring> m_col_name;
    Gtk::TreeModelColumn<Gnome::Vfs::FileSize> m_col_size;
  };

  void init_data();

  void append_text_size(const Glib::ustring& text, Gnome::Vfs::FileSize size);

  DiscSizeType get_enum_size() const;
  Gnome::Vfs::FileSize get_byte_size() const;
  Glib::ustring get_label_size() const;

  void set_size(DiscSizeType size);
  void set_size(int size); // from gconf

protected:
private:
  ComboColumns m_Columns;
  Glib::RefPtr<Gtk::ListStore> m_refStore;
};

} // namespace Widgets
  
} // namespace Coaster

#endif // _COASTER_COMBO_DISC_SIZE_H_
