/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "widgets/combo-disc-size.h"

#include "cstr-intl.h"
#include "ucompose.h"

#include "conf/conf-utils.h"

#include <gtkmm/liststore.h>
#include <gtkmm/cellrenderertext.h>

#include <libglademm/xml.h>
#include <libgnomevfsmm/utils.h>

namespace Coaster
{

namespace Widgets
{

ComboDiscSize::ComboDiscSize()
{
  using namespace Gtk;
  m_refStore = ListStore::create(m_Columns);

  set_model(m_refStore);

  CellRendererText *const cell_name = new CellRendererText();
  pack_start(*manage(cell_name), true);
  add_attribute(cell_name->property_text(), m_Columns.m_col_name);
}

ComboDiscSize::ComboDiscSize(BaseObjectType* cobject,
                             const Glib::RefPtr<Gnome::Glade::Xml>& refXml)
: Gtk::ComboBox(cobject)
{
  using namespace Gtk;
  m_refStore = ListStore::create(m_Columns);

  set_model(m_refStore);

  CellRendererText *const cell_name = new CellRendererText();
  pack_start(*manage(cell_name), true);
  add_attribute(cell_name->property_text(), m_Columns.m_col_name);

  {
    Gnome::Vfs::FileSize size;

    size = 194000000;
    append_text_size(_("Mini-CD (185 MB)"), size);

    size = 682000000;
    append_text_size(_("CD (650 MB / 74 min.)"), size);

    size = 737000000;
    append_text_size(_("CD (700 MB / 80 min.)"), size);

    size = 786432000;
    append_text_size(_("CD (750 MB)"), size);

    size = 838860800;
    append_text_size(_("CD (800 MB)"), size);

    size = 4700000000ULL;
    append_text_size(_("DVD-5 (4.37 GB)"), size);

    size = 8540000000ULL;
    append_text_size(_("DVD-9 (7.95 GB)"), size);
  }
}

ComboDiscSize::~ComboDiscSize()
{}

void ComboDiscSize::append_text_size(const Glib::ustring& text, Gnome::Vfs::FileSize size)
{
  Gtk::TreeRow row = *(m_refStore->append());
  row[m_Columns.m_col_name] = text;
  row[m_Columns.m_col_size] = size;
}

DiscSizeType ComboDiscSize::get_enum_size() const
{
  int active_row = get_active_row_number();

  switch(active_row)
  {
    case 0:
      return COASTER_DISC_SIZE_185;
    default:
    case 1:
      return COASTER_DISC_SIZE_650;
    case 2:
      return COASTER_DISC_SIZE_700;
    case 3:
      return COASTER_DISC_SIZE_750;
    case 4:
      return COASTER_DISC_SIZE_800;
    case 5:
      return COASTER_DISC_SIZE_DVD5;
    case 6:
      return COASTER_DISC_SIZE_DVD9;
  }
}

Gnome::Vfs::FileSize ComboDiscSize::get_byte_size() const
{
  return (*(get_active())).get_value(m_Columns.m_col_size);
}

Glib::ustring ComboDiscSize::get_label_size() const
{
  return (*(get_active())).get_value(m_Columns.m_col_name);
}

void ComboDiscSize::set_size(DiscSizeType size)
{
  set_active(size - 1);
}

void ComboDiscSize::set_size(int size)
{
  if(size >= 0 && size <= 6)
    set_active(size);
  else
    set_active(Conf::get_int("layouts/default_size"));
}

void ComboDiscSize::init_data()
{
  Gnome::Vfs::FileSize size;

  size = 194000000;
  append_text_size(_("Mini-CD (185 MB)"), size);

  size = 682000000;
  append_text_size(_("CD (650 MB)"), size);

  size = 737000000;
  append_text_size(_("CD (700 MB)"), size);

  size = 786432000;
  append_text_size(_("CD (750 MB)"), size);

  size = 838860800;
  append_text_size(_("CD (800 MB)"), size);

  size = 4700000000ULL;
  append_text_size(_("DVD-5 (4.37 GB)"), size);

  size = 8540000000ULL;
  append_text_size(_("DVD-9 (7.95 GB)"), size);
}

} // namespace Widgets

} // namespace Coaster
