/* Copyright (C) 2002-2005  The Coaster Development Team
 * Adapted from Rhythmbox's Ellipsized Label
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "widgets/cellrenderer-uri.h"

#include "cstr-debug.h"
#include <libgnomevfsmm/utils.h>

namespace Coaster
{

namespace Widgets
{

CellRendererUri::CellRendererUri()
: Glib::ObjectBase(typeid(CellRendererUri)),
  Gtk::CellRendererText()
{
  property_mode() = Gtk::CELL_RENDERER_MODE_EDITABLE;
  property_ellipsize() = Pango::ELLIPSIZE_START;
}

CellRendererUri::~CellRendererUri()
{}

void CellRendererUri::render_vfunc(const Glib::RefPtr<Gdk::Drawable>& window,
                                   Gtk::Widget& widget,
                                   const Gdk::Rectangle& background_area,
                                   const Gdk::Rectangle& cell_area,
                                   const Gdk::Rectangle& expose_area,
                                   Gtk::CellRendererState flags)
{
  if(property_text() == "")
    return;

  property_text() = Gnome::Vfs::unescape_string(property_text());

  Gtk::CellRendererText::render_vfunc(window,
                                      widget,
                                      background_area,
                                      cell_area,
                                      expose_area,
                                      flags);
}

} // namespace Widgets

} // namespace Coaster
