/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "widgets/busy-cursor.h"

#include <gtkmm/main.h>

namespace Coaster
{

namespace Widgets
{

BusyCursor::BusyCursor(Gtk::Window& window,
                       Gdk::CursorType cursor_type)
: m_Cursor(cursor_type)
{
  m_refWindow = window.get_window();

  //Change the cursor:
  m_refWindow->set_cursor(m_Cursor);
  
  force_gui_update();
}

BusyCursor::~BusyCursor()
{
  //Restore the old cursor:
  m_refWindow->set_cursor();
  
  force_gui_update();
}

void BusyCursor::force_gui_update()
{
  //Force the GUI to update:
  while(Gtk::Main::events_pending())
    Gtk::Main::iteration();
}

} // namespace Widgets

} // namespace Coaster
