/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_STRING_UTILS_H_
#define _COASTER_STRING_UTILS_H_

#include "cstr-types.h"

namespace Coaster
{

namespace String
{

Glib::ustring create_full_uri(const Glib::ustring& path);
Glib::ustring create_full_path(const Glib::ustring& path);
bool is_uri(const Glib::ustring& path);

Glib::ustring replace_home_dir_with_tilde(const Glib::ustring& uri);
Glib::ustring get_dirname(const Glib::ustring& uri);
Glib::ustring middle_truncate(const Glib::ustring& string,
                              unsigned int truncate_length);

Glib::ustring uri_get_basename(const Glib::ustring& uri);

type_list_ustrings uri_list_extract_uris(const Glib::ustring& uri_list);

} // namespace String

} // namespace Coaster

#endif // _COASTER_STRING_UTILS_H_
