/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_STORE_BASE_H_
#define _COASTER_STORE_BASE_H_

#include <sigc++/trackable.h>

#include "sharedptr.h"
#include "cstr-types.h"

#include <sigc++/signal.h>

#include <gtkmm/treemodel.h>
#include <gtkmm/treeselection.h>

namespace Coaster
{

class UndoOp;
typedef SharedPtr<UndoOp> UndoOpPtr;

class Store_Base
{
public:
  // slot types
  typedef sigc::slot<void,const UndoOpPtr&> type_slot_push_undo;
  typedef sigc::slot<bool,const Glib::ustring&> type_slot_report_file;

  // signal types
  typedef sigc::signal<void,bool> type_signal_modified;

  virtual ~Store_Base();

  // member method setting
  void set_push_undo(const type_slot_push_undo& slot_push_undo);
  void set_tree_selection(const Glib::RefPtr<Gtk::TreeSelection>& tree_selection);

  // searching
  void search(const Glib::ustring& search_string);

  // signal accessors
  type_signal_modified& signal_modified();

  // override these:
  virtual bool has_files() const = 0;

  // cut/copy/paste
  virtual void cut() = 0;
  virtual void copy() = 0;
  virtual void paste() = 0;

  // adding/removing to the store
  // from the view
  virtual void add_files(const type_list_ustrings& files,
                         bool hidden,
                         const type_slot_report_file& slot_report) = 0;
  virtual void add_folder(const Glib::ustring& directory,
                          bool hidden,
                          bool recursive,
                          bool follow_links,
                          const type_slot_report_file& slot_report) = 0;
  virtual void remove(bool cut = false) = 0;
  virtual void clear(bool revert = false) = 0;

  // String methods
  virtual Glib::ustring get_contents(bool internal = false,
                                     bool save_parent_path = false) const = 0;
  virtual bool set_contents(const Glib::ustring& contents) = 0;

protected:
  Store_Base();

  // searching methods
  virtual void search_case(const Glib::ustring& search_string) = 0;
  virtual void search_nocase(const Glib::ustring& search_string) = 0;
  virtual bool on_search_foreach_case(const Gtk::TreeIter& iter,
                                      const Glib::ustring& search_string) const = 0;
  virtual bool on_search_foreach_nocase(const Gtk::TreeIter& iter,
                                        const Glib::ustring& search_string) const = 0;

  // Icon Theme methods
  virtual void on_icon_theme_changed() = 0;
  virtual bool icon_theme_changed_foreach(const Gtk::TreeModel::iterator& iter) = 0;

  // member variables
  Glib::RefPtr<Gtk::TreeSelection> m_refSelection;

  // slots
  type_slot_push_undo push_undo;

  // signals
  type_signal_modified m_signal_modified;
};

} // namespace Coaster

#endif // _COASTER_STORE_BASE_H_
