/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "store-base.h"

#include "icon-cache.h"
#include "undo-op.h"

#include "conf/conf-utils.h"

#include <gtkmm/treeselection.h>

namespace Coaster
{

Store_Base::Store_Base()
{
  IconCache::signal_icon_theme_changed().connect(
                                  sigc::mem_fun(*this, &Store_Base::on_icon_theme_changed));
}

Store_Base::~Store_Base()
{}

void Store_Base::set_push_undo(const type_slot_push_undo& slot_push_undo)
{
  push_undo = slot_push_undo;
}

void Store_Base::set_tree_selection(const Glib::RefPtr<Gtk::TreeSelection>& tree_selection)
{
  m_refSelection = tree_selection;
}

void Store_Base::search(const Glib::ustring& search_string)
{
  bool match_case = Conf::get_bool("search/match_case");

  if(match_case)
    search_case(search_string);
  else
    search_nocase(search_string);
}

Store_Base::type_signal_modified& Store_Base::signal_modified()
{
  return m_signal_modified;
}

} // namespace Coaster
