/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_STOCK_H_
#define _COASTER_STOCK_H_

#include <glibmm/ustring.h>

namespace Gtk { struct BuiltinStockID; }

namespace Coaster
{

namespace Stock
{

void init();

extern const Gtk::BuiltinStockID AUDIO;
extern const Gtk::BuiltinStockID DATA;
extern const Gtk::BuiltinStockID MIX;
extern const Gtk::BuiltinStockID VIDEO;

extern const Gtk::BuiltinStockID ADD_FILES;
extern const Gtk::BuiltinStockID ADD_FOLDER;

extern const Gtk::BuiltinStockID DISC;
extern const Gtk::BuiltinStockID DISC_BURN;
extern const Gtk::BuiltinStockID DISC_COPY;
extern const Gtk::BuiltinStockID DISC_ERASE;
extern const Gtk::BuiltinStockID DISC_IDLE;
extern const Gtk::BuiltinStockID DISC_INFO;

extern const Gtk::BuiltinStockID SESSION;
extern const Gtk::BuiltinStockID ADD_SESSION;
extern const Gtk::BuiltinStockID REMOVE_SESSION;

} // namespace Stock

} // namespace Coaster

#endif // _COASTER_STOCK_H_
