/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "status-icon.h"

#include "cstr-debug.h"
#include "cstr-intl.h"
#include "exception.h"
#include "ucompose.h"

#include "widgets/tray-icon.h"

#include <gdkmm/pixbuf.h>

#include <gtkmm/eventbox.h>
#include <gtkmm/image.h>
#include <gtkmm/tooltips.h>

#include <iomanip>

namespace Coaster
{

namespace StatusIcon
{

namespace
{

Coaster::Widgets::TrayIcon* status_icon = 0;

void init()
{
  if(!status_icon)
  {
    status_icon = new Widgets::TrayIcon();
  }
}

} // anonymous namespace

void set(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf,
         const Glib::ustring& tip,
         const Glib::ustring& private_tip)
{
  init();
  status_icon->set(pixbuf, tip, private_tip);
}

void set(const Glib::ustring& tip,
         const Glib::ustring& private_tip)
{
  init();
  status_icon->set(tip, private_tip);
}

void set(const Glib::ustring& tip,
         double fraction)
{
  init();
  std::ostringstream oss;
  oss.imbue(std::locale(""));
  
  oss << tip << "  " << std::fixed << std::setprecision(2) << fraction << "%";

  status_icon->set(Glib::locale_to_utf8(oss.str()), "");
}

void remove()
{
  if(status_icon)
  {
    delete status_icon;
    status_icon = 0;
    return;
  }
}

} // namespace StatusIcon

} // namespace Coaster
