#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include "ncbmm/wrap_init.h"
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "ncbmm/recorder.h"
#include "ncbmm/drive-selection.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType nautilus_burn_recorder_get_type(void);
GType nautilus_burn_drive_selection_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"

//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Nautilus {
namespace Burn {
  class Recorder_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };
  class DriveSelection_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };
} // namespace Burn
} // namespace Nautilus

namespace Nautilus {

namespace Burn {

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(nautilus_burn_recorder_get_type(), &Nautilus::Burn::Recorder_Class::wrap_new);
  Glib::wrap_register(nautilus_burn_drive_selection_get_type(), &Nautilus::Burn::DriveSelection_Class::wrap_new);

  // Register the gtkmm gtypes:
  Nautilus::Burn::Recorder::get_type();
  Nautilus::Burn::DriveSelection::get_type();
  
} // wrap_init()

} // namespace Burn

} // namespace Nautilus
