// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _NCBMM_RECORDER_H
#define _NCBMM_RECORDER_H

#include <glibmm.h>

/* Copyright (C) 2005 The Coaster Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// Class Includes
#include <glibmm/error.h>
#include <glib-object.h>
#include <nautilus-burn-recorder.h>

namespace Nautilus
{

namespace Burn
{

class Recorder_Class;

enum RecorderWriteFlags
{
  RECORDER_EJECT			= 1 << 0,
  RECORDER_BLANK			= 1 << 1,
  RECORDER_DUMMY_WRITE			= 1 << 2,
  RECORDER_DISC_AT_ONCE			= 1 << 3,
  RECORDER_DEBUG			= 1 << 4,
  RECORDER_OVERBURN			= 1 << 5,
  RECORDER_BURNPROOF			= 1 << 6
};

inline RecorderWriteFlags operator|(RecorderWriteFlags lhs, RecorderWriteFlags rhs)
  { return static_cast<RecorderWriteFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

inline RecorderWriteFlags operator&(RecorderWriteFlags lhs, RecorderWriteFlags rhs)
  { return static_cast<RecorderWriteFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

inline RecorderWriteFlags operator^(RecorderWriteFlags lhs, RecorderWriteFlags rhs)
  { return static_cast<RecorderWriteFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

inline RecorderWriteFlags operator~(RecorderWriteFlags flags)
  { return static_cast<RecorderWriteFlags>(~static_cast<unsigned>(flags)); }

inline RecorderWriteFlags& operator|=(RecorderWriteFlags& lhs, RecorderWriteFlags rhs)
  { return (lhs = static_cast<RecorderWriteFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

inline RecorderWriteFlags& operator&=(RecorderWriteFlags& lhs, RecorderWriteFlags rhs)
  { return (lhs = static_cast<RecorderWriteFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

inline RecorderWriteFlags& operator^=(RecorderWriteFlags& lhs, RecorderWriteFlags rhs)
  { return (lhs = static_cast<RecorderWriteFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

enum RecorderResult
{
  RECORDER_RESULT_ERROR,
  RECORDER_RESULT_CANCEL,
  RECORDER_RESULT_FINISHED,
  RECORDER_RESULT_RETRY
};

enum RecorderBlankType
{
  RECORDER_BLANK_FAST,
  RECORDER_BLANK_FULL
};

enum RecorderActions
{
	RECORDER_PREPARING_WRITE,
	RECORDER_WRITING,
	RECORDER_FIXATING,
	RECORDER_BLANKING
};

enum RecorderMedia
{
	RECORDER_MEDIA_CD,
	RECORDER_MEDIA_DVD,
};

class Recorder : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Recorder CppObjectType;
  typedef Recorder_Class CppClassType;
  typedef NautilusBurnRecorder BaseObjectType;
  typedef NautilusBurnRecorderClass BaseClassType;

private:  friend class Recorder_Class;
  static CppClassType recorder_class_;

private:
  // noncopyable
  Recorder(const Recorder&);
  Recorder& operator=(const Recorder&);

protected:
  explicit Recorder(const Glib::ConstructParams& construct_params);
  explicit Recorder(NautilusBurnRecorder* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Recorder();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  NautilusBurnRecorder*       gobj()       { return reinterpret_cast<NautilusBurnRecorder*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const NautilusBurnRecorder* gobj() const { return reinterpret_cast<NautilusBurnRecorder*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  NautilusBurnRecorder* gobj_copy();

private:

  
  //typedef sigc::slot<void, 
protected:
  Recorder();


public:
  static Glib::RefPtr<Recorder> create();

  int write_tracks(NautilusBurnDrive* drive, GList* tracks, int speed, RecorderWriteFlags flags);
  int blank_disc(NautilusBurnDrive* drive, RecorderBlankType type, bool debug);

  bool cancel(bool skip_if_dangerous);

  Glib::ustring get_error_message() const;
  Glib::ustring get_error_message_details() const;

  Glib::SignalProxy1<void,double> signal_progress_changed();
  Glib::SignalProxy2<void,RecorderActions,RecorderMedia> signal_action_changed();
  Glib::SignalProxy1<void,bool> signal_animation_changed();
  Glib::SignalProxy3<void,bool,bool,bool> signal_insert_cd_request();
  Glib::SignalProxy0<bool> signal_warn_data_loss();

  void on_progress_changed(double percentage);
  void on_action_changed(RecorderActions action, RecorderMedia media);
  void on_animation_changed(bool spinning);
  void on_insert_cd_request(bool is_reload, bool can_rewrite, bool busy);
  bool on_warn_data_loss();

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Burn

} // namespace Nautilus


namespace Glib
{
  /** @relates E::Recorder
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Nautilus::Burn::Recorder> wrap(NautilusBurnRecorder* object, bool take_copy = false);
}


#endif /* _NCBMM_RECORDER_H */

