#ifndef _NCBMM_DRIVE_SELECTION_H
#define _NCBMM_DRIVE_SELECTION_H

#include <glibmm.h>

/* cd-selection.h
 * 
 * Copyright (C) 2002-2005 The Coaster Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/combobox.h>
#include <nautilus-burn-drive-selection.h>

namespace Nautilus
{

namespace Burn
{

class DriveSelection_Class;

class DriveSelection : public Gtk::ComboBox
{
public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DriveSelection CppObjectType;
  typedef DriveSelection_Class CppClassType;
  typedef NautilusBurnDriveSelection BaseObjectType;
  typedef NautilusBurnDriveSelectionClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~DriveSelection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class DriveSelection_Class;
  static CppClassType cd_selection_class_;

  // noncopyable
  DriveSelection(const DriveSelection&);
  DriveSelection& operator=(const DriveSelection&);

protected:
  explicit DriveSelection(const Glib::ConstructParams& construct_params);
  explicit DriveSelection(NautilusBurnDriveSelection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  NautilusBurnDriveSelection*       gobj()       { return reinterpret_cast<NautilusBurnDriveSelection*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const NautilusBurnDriveSelection* gobj() const { return reinterpret_cast<NautilusBurnDriveSelection*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:
  DriveSelection();

  void set_device(const Glib::ustring& device);

  Glib::ustring get_device() const;

  Glib::ustring get_default_device() const;

  const NautilusBurnDrive* get_cdrom() const;

  Glib::PropertyProxy<Glib::ustring> property_device();
  Glib::PropertyProxy<bool> property_file_image();
  Glib::PropertyProxy<bool> property_show_recorders_only();

  Glib::SignalProxy1<void,const Glib::ustring&> signal_device_changed();

  void on_device_changed(const Glib::ustring& device);
};

} // namespace Burn

} // namespace Nautilus

namespace Glib
{
  Nautilus::Burn::DriveSelection* wrap(NautilusBurnDriveSelection* object, bool take_copy = false);
}


#endif /* _NCBMM_DRIVE_SELECTION_H */
