/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_MAINWINDOW_H_
#define _COASTER_MAINWINDOW_H_

#include <gtkmm/window.h>

#include <gconfmm/entry.h>

#include "cstr-enums.h"
#include "sharedptr.h"

extern "C"
{
typedef struct _EggRecentItem EggRecentItem;
}

namespace Gtk
{
class ActionGroup;
class Action;
class Alignment;
class HandleBox;
class MenuBar;
class Statusbar;
class Toolbar;
class UIManager;
class VBox;
} // namespace Gtk

namespace Gnome
{
namespace Conf
{
class Client;
} // namespace Conf
} // namespace Client

namespace Coaster
{

namespace Widgets
{
class View_Base;
} // namespace Widgets

class MainWindow : public Gtk::Window
{
public:
  friend class InstanceMgr;

  MainWindow();
  virtual ~MainWindow();

  //bool init(const Glib::ustring& document_uri = Glib::ustring());
  void init(const Glib::ustring& file_uri = Glib::ustring());

  bool is_doc_new() const;
  Glib::ustring get_file_uri() const;
  void set_file_uri(const Glib::ustring& file_uri);

  typedef sigc::slot<void, EggRecentItem*> type_slot_recent_item;

protected:
  int add_ui_from_file(const Glib::ustring& filename);

  void init_ui();
  void init_layout();
  void init_recent_files();

  void init_file_actions();
  void init_edit_actions();
  void init_other_actions();
  void init_help_actions();

  void open(const Glib::ustring& file_uri);
  bool save();
  bool saveas();
  bool load();
  void close(bool warn);

  void show_handlebar(bool show = true);
  void on_toolbar_detachable_changed(guint connection,
                                     Gnome::Conf::Entry entry);

  bool on_delete_event(GdkEventAny* event);

  void on_menu_file_new();
  void on_menu_file_open();
  void on_recent_files_activate(EggRecentItem* item);
  void on_menu_file_save();
  void on_menu_file_saveas();
  void on_menu_file_revert();
  void on_menu_file_close();
  void on_menu_file_exit();

  void on_preferences();
  void on_burn_iso();
  void on_copy_disc();
  void on_erase_disc();

  void on_menu_help_contents();
  void on_menu_help_about();

  void on_view_modified(bool modified);
  void on_view_sensitive(bool sensitive);

  void on_ui_connect(const Glib::RefPtr<Gtk::Action>& action,
                     Gtk::Widget* widget);
  void on_show_menu_tip(const Glib::RefPtr<Gtk::Action>& action);
  void on_clear_menu_tip();

  void update_window_title();
  Glib::ustring get_doc_short_name() const;
  Glib::ustring get_doc_dirname(bool for_title = true) const;
  
private:
  SharedPtr<InstanceMgr> m_instmgr;

  Glib::RefPtr<Gnome::Conf::Client> m_refClient;
  guint m_toolbar_detachable_cnxn;

  Glib::RefPtr<Gtk::UIManager> m_refUIManager;
  int m_last_view_merge_ui;

  // Widgets
  Gtk::VBox*    m_pMain_VBox;
  Gtk::VBox*    m_pView_VBox;
  Gtk::MenuBar* m_pMenuBar;

  Gtk::HandleBox* m_pHandleBox;
  Gtk::Alignment* m_pAlignment;
  Gtk::Toolbar*   m_pToolbar;

  Widgets::View_Base* m_pView;
  Gtk::Statusbar* m_pStatus;

  // Action Groups
  Glib::RefPtr<Gtk::ActionGroup> m_refFileActionGroup;
  Glib::RefPtr<Gtk::ActionGroup> m_refEditActionGroup;
  Glib::RefPtr<Gtk::ActionGroup> m_refOtherActionGroup;
  Glib::RefPtr<Gtk::ActionGroup> m_refHelpActionGroup;

  // Actions
  Glib::RefPtr<Gtk::Action> m_refSaveAction;
  Glib::RefPtr<Gtk::Action> m_refSaveAsAction;
  Glib::RefPtr<Gtk::Action> m_refRevertAction;
  Glib::RefPtr<Gtk::Action> m_refEjectAction;
  Glib::RefPtr<Gtk::Action> m_refEraseAction;

  // Slots
  type_slot_recent_item m_slot_recent_files_activate;
 
  // Document variables
  Glib::ustring m_file_uri;
  bool m_bNew;
};

} // namespace Coaster

#endif // _COASTER_MAINWINDOW_H_
