/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <unistd.h>
#include <config.h>

#include "cstr-intl.h"
#include "cstr-debug.h"
#include "cstr-strings.h"
#include "cstr-types.h"
#include "exception.h"

#include "status-icon.h"
#include "icon-cache.h"

#include "mainwindow.h"
#include "instance-manager.h"
#include "stock.h"

#include <gtkmm/main.h>
#include <gconfmm/init.h>
#include <libgnomevfsmm/init.h>
#include "ncbmm/wrap_init.h"

#include <libgnome/gnome-init.h>
#include <libgnomeui/gnome-ui-init.h>

#include <exception>

namespace Coaster
{

Glib::OptionGroup option_group(_("Coaster"),
                               _("A Disc Burning Tool"),
                               _("Help description"));

bool coaster_debug = false;
bool coaster_debug_xml = false;
bool coaster_debug_dnd = false;
type_vec_strings coaster_filenames;

void init()
{
  Gnome::Conf::init();
  Gnome::Vfs::init();
#ifdef COASTER_BACKEND_NAUTILUS
  Nautilus::Burn::wrap_init();
#endif // COASTER_BACKEND_NAUTILUS
  IconCache::init();
  Stock::init();
}

void setup_option_group(Glib::OptionContext& context,
                        const Glib::ustring& text_domain)
{
  Glib::OptionEntry entry1;
  entry1.set_long_name("debug");
  entry1.set_description(_("Enable debugging statements"));
  option_group.add_entry(entry1, coaster_debug);

  Glib::OptionEntry entry2;
  entry2.set_long_name("debug-xml");
  entry2.set_description(_("Enable xml debugging statements"));
  option_group.add_entry(entry2, coaster_debug_xml);

  Glib::OptionEntry entry3;
  entry3.set_long_name("debug-dnd");
  entry3.set_description(_("Enable DnD debugging statements"));
  option_group.add_entry(entry3, coaster_debug_dnd);

  Glib::OptionEntry entry4;
  entry4.set_long_name("");
  option_group.add_entry_filename(entry4, coaster_filenames);

  option_group.set_translation_domain(text_domain);
  context.set_main_group(option_group);
}

} // namespace Coaster

int main(int argc,
         char **argv)
{
  //Make this application use the current locale for gettext() translation:
  bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);  //LOCALEDIR is defined in the Makefile.am
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);
  
	try
	{
    Glib::init();

    Glib::OptionContext context(_("- A Disc Burning Tool"));
    Coaster::setup_option_group(context, GETTEXT_PACKAGE);
    Gtk::Main mainInstance(argc, argv, context);

    gnome_program_init(PACKAGE_NAME, PACKAGE_VERSION, LIBGNOMEUI_MODULE,
                       argc, argv,
                       GNOME_PROGRAM_STANDARD_PROPERTIES,
                       NULL);

    Coaster::init();

    if(Coaster::debug())
    {
      for(Coaster::type_vec_strings::iterator i = Coaster::coaster_filenames.begin() ;
          i != Coaster::coaster_filenames.end() ;
          ++i)
      {
        Coaster::debug(*i);
      }
    }

    Coaster::SharedPtr<Coaster::InstanceMgr> instmgr = Coaster::InstanceMgr::instance();
    instmgr->init(Coaster::coaster_filenames);

    gdk_threads_enter();
    Gtk::Main::run();
    gdk_threads_leave();
	}
  catch(const Glib::Exception& ex)
  {
    Coaster::handle_exception("unhandled exception: \n", ex);
  }
	catch(const std::exception& except)
	{
		g_error("unhandled exception: %s", except.what());
	}
	catch(...)
	{
		g_error("unhandled exception: type unknown");
	}

  Coaster::StatusIcon::remove(); // delete the status icon
	return 0;
}
