/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_INSTANCE_MANAGER_H_
#define _COASTER_INSTANCE_MANAGER_H_

#include "sharedptr.h"

#include "cstr-types.h"

#include <gtkmm/window.h>
#include <gtkmm/treerowreference.h>
#include <gconfmm/entry.h>

namespace Gdk
{
class Pixbuf;
} // namespace Gdk

namespace Gtk
{
class MessageDialog;
class TreeStore;
} // namespace Gtk

extern "C"
{
typedef struct _EggRecentModel EggRecentModel;
}

namespace Coaster
{

class MainWindow;

namespace Dialogs
{
class About;
} // namespace Dialogs

typedef enum
{
  OPEN_FAILED,
  OPEN_ALREADY,
  OPEN_SUCCESS
} OpenReturnValues;

class InstanceMgr : public SharedObject
{
public:
  typedef sigc::signal<void,bool> type_signal_sensitive;
  typedef std::list<MainWindow*>  type_list_coaster_apps;

  InstanceMgr();
  virtual ~InstanceMgr();

  // Static methods
  static SharedPtr<InstanceMgr> instance();

  // Initialization
  void init(const type_vec_strings& filenames);

  virtual void new_window();
  virtual OpenReturnValues open(const Glib::ustring& file_uri,
                                bool might_need_new_instance,
                                MainWindow* caller);
  virtual void add(MainWindow* pMW);
  virtual void close_all();
  virtual void cancel_close_all();

  virtual unsigned int get_count() const;

  virtual type_list_coaster_apps get_instances() const;

  // Dialogs
  void show_about(Gtk::Window& window);
  void show_help(Gtk::Window& window,
                 const Glib::ustring& link_id = Glib::ustring());

  void on_about_dialog_hide();
  void on_help_error_dialog_hide();

  // Recent Files
  EggRecentModel* get_recent_model() const;
  void document_history_add(const Glib::ustring& uri);
  void document_history_remove(const Glib::ustring& uri);

  // instance manager signals
  type_signal_sensitive& signal_sensitive();
  void set_sensitive(bool sensitive = true);

protected:
  void on_hide(MainWindow* pMW);

  MainWindow* is_already_open(const Glib::ustring& file_uri);

private:
  // Instances
  type_list_coaster_apps m_list_instances;
  std::auto_ptr<Dialogs::About> m_pAbout;
  std::auto_ptr<Gtk::MessageDialog> m_pHelpError;
  EggRecentModel* m_recent_files_model;

  // sensitive signal
  type_signal_sensitive m_signal_sensitive;

  bool m_bExiting;
};

//typedef SharedPtr<InstanceMgr> InstanceMgrPtr;

} // namespace Coaster

#endif // _COASTER_INSTANCE_MANAGER_H_
