/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_EXCEPTION_H_
#define _COASTER_EXCEPTION_H_

#include <glibmm/exception.h>
#include <glibmm/ustring.h>

namespace Coaster
{

class Exception : public Glib::Exception
{
public:
  explicit Exception(const Glib::ustring& description);
  virtual ~Exception() throw();

  Glib::ustring what() const;
  
private:
  Glib::ustring desc;
};

void handle_exception(const Glib::ustring& prefix, const Exception& ex);
void handle_exception(const Glib::ustring& prefix, const Glib::Exception& ex);
void handle_exception(const Glib::ustring& prefix, const std::exception& ex);

} // namespace Coaster

#endif // _COASTER_EXCEPTION_H_
