/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "exception.h"

#include <iostream>

namespace Coaster
{

Exception::Exception(const Glib::ustring& description)
: desc(description)
{}

Exception::~Exception() throw()
{}

Glib::ustring Exception::what() const
{
  return desc;
}

void handle_exception(const Glib::ustring& prefix, const Exception& ex)
{
  std::cerr << prefix << ex.what() << std::endl;
}

void handle_exception(const Glib::ustring& prefix, const Glib::Exception& ex)
{
  std::cerr << prefix << ex.what() << std::endl;
}

void handle_exception(const Glib::ustring& prefix, const std::exception& ex)
{
  std::cerr << prefix << ex.what() << std::endl;
}

} // namespace Coaster
