/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "edit-ops.h"

#include "cstr-debug.h"
#include <gtkmm/clipboard.h>
#include <list>

namespace
{

const char *TARGET_DATA_ROW = "application/x-coaster/data-row";

/*struct
{
  std::string           target;
  char                 *buffer;
  Gnome::Vfs::FileSize  length;

  void reset()
  {
    xmlFree(buffer);
    target = "";
    buffer = 0;
    length = 0;
  }

  void set_data(Gtk::SelectionData& data)
  {
    if(data.get_target() != target)
      return;
     data.set(target, 8, (guchar*)buffer, length);
  }
} clipboard_contents = { "", 0, 0 };*/

struct
{
  Glib::ustring target;
  Glib::ustring buffer;

  void reset()
  {
    target.clear();
    buffer.clear();
  }

  void set_data(Gtk::SelectionData& data)
  {
    if(data.get_target() != target)
      return;
    data.set(target, 8, (guchar*)buffer.c_str(), buffer.bytes());
  }
} clip_cont = { "", "" };

sigc::slot<void,const Glib::ustring&> add_from_string;

void paste_data(const Gtk::SelectionData& data)
{
  add_from_string(data.get_data_as_string());
}

void selection_requested_cb(Gtk::SelectionData& data,
                            guint info)
{
  clip_cont.set_data(data);
  Coaster::debug_xml("Copied:\n", data.get_data_as_string());
}

void selection_received_cb(const Gtk::SelectionData& data)
{
  if(data.get_data_as_string().empty())
    return;

  Coaster::debug("Paste target: ",data.get_target());
  if(data.get_target() == TARGET_DATA_ROW)
    paste_data(data);
  
  /*else if (data.get_target () == TARGET_WIDGET)
    paste_widgets_impl (data);*/
}

void selection_cleared_cb ()
{
  // Do nothing
}

} // anonymous namespace

namespace Coaster
{

namespace Edit
{

void copy_data_rows(const Glib::ustring& str)
{
  /*xmlChar **buffer_addr = &reinterpret_cast<xmlChar*&>(clipboard_contents.buffer);
  int buffer_size_tmp;
  
  xmlDocDumpMemory(const_cast<xmlDoc*>(document->cobj()), buffer_addr, &buffer_size_tmp);
  clipboard_contents.length = buffer_size_tmp;*/

  clip_cont.buffer = str;

  std::list<Gtk::TargetEntry> targets;
  targets.push_back(Gtk::TargetEntry(TARGET_DATA_ROW));
  clip_cont.target = TARGET_DATA_ROW;

  Glib::RefPtr<Gtk::Clipboard> clipboard = Gtk::Clipboard::get();
  clipboard->set(targets,
                 sigc::ptr_fun(selection_requested_cb),
                 sigc::ptr_fun(selection_cleared_cb));
}

void paste_data_rows(const sigc::slot<void,const Glib::ustring&>& add_slot)
{
  add_from_string = add_slot;
  
  Glib::RefPtr<Gtk::Clipboard> clipboard = Gtk::Clipboard::get();
  clipboard->request_contents(TARGET_DATA_ROW, sigc::ptr_fun(selection_received_cb));
}

} // namespace Edit

} // namespace Coaster
