/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_PROGRESS_BASE_H_
#define _COASTER_PROGRESS_BASE_H_

#include <gtkmm/dialog.h>

namespace Gtk
{
class Label;
class ProgressBar;
} // namespace Gtk

namespace Coaster
{

namespace Dialogs
{

class Progress : public Gtk::Dialog
{
public:
  static std::auto_ptr<Progress> create(Gtk::Window& parent,
                                        const Glib::ustring& title,
                                        const Glib::ustring& primary,
                                        const Glib::ustring& secondary,
                                        const Glib::ustring& initial_status);
  virtual ~Progress();

  void set_progress(double fraction);
  void pulse();

  void set_primary(const Glib::ustring& text);
  void set_secondary(const Glib::ustring& text);
  void set_status(const Glib::ustring& text);

protected:
  explicit Progress(Gtk::Window& parent,
                    const Glib::ustring& title,
                    const Glib::ustring& primary,
                    const Glib::ustring& secondary,
                    const Glib::ustring& initial_status);

private:
  Gtk::Label*       m_pPrimary_Label;
  Gtk::Label*       m_pSecondary_Label;
  
  Gtk::ProgressBar* m_pProgressBar;
  Gtk::Label*       m_pStatus_Label;
};

} // namespace Dialogs

} // namespace Coaster

#endif // _COASTER_PROGRESS_BASE_H_
