/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "dialogs/progress.h"

#include "ucompose.h"

#include <gtkmm/label.h>
#include <gtkmm/progressbar.h>

namespace Coaster
{

namespace Dialogs
{

Progress::Progress(Gtk::Window& parent,
                   const Glib::ustring& title,
                   const Glib::ustring& primary,
                   const Glib::ustring& secondary,
                   const Glib::ustring& initial_status)
: Gtk::Dialog(title, parent, true, false),
  m_pPrimary_Label(0), m_pSecondary_Label(0),
  m_pProgressBar(0), m_pStatus_Label(0)
{
  set_title(title);
  set_transient_for(parent);

  set_border_width(6);
  get_vbox()->set_spacing(12);

  Gtk::VBox* main_vbox = new Gtk::VBox();
  main_vbox->set_border_width(6);
  main_vbox->set_spacing(18);
  get_vbox()->pack_start(*manage(main_vbox));

  {
    Gtk::VBox* text_vbox = new Gtk::VBox();
    text_vbox->set_spacing(6);
    main_vbox->pack_start(*manage(text_vbox));

    m_pPrimary_Label = new Gtk::Label();
    m_pPrimary_Label->set_use_markup();
    m_pPrimary_Label->set_alignment(0.0, 0.5);
    m_pPrimary_Label->set_markup(String::ucompose("<b><span size='larger'>%1</span></b>", primary));
    text_vbox->pack_start(*manage(m_pPrimary_Label));

    m_pSecondary_Label = new Gtk::Label();
    m_pSecondary_Label->set_use_markup();
    m_pSecondary_Label->set_alignment(0.0, 0.5);
    m_pSecondary_Label->set_line_wrap();
    m_pSecondary_Label->set_markup(secondary);
    text_vbox->pack_start(*manage(m_pSecondary_Label));
  }

  {
    Gtk::VBox* prog_vbox = new Gtk::VBox();
    prog_vbox->set_spacing(0);
    main_vbox->pack_start(*manage(prog_vbox));

    m_pProgressBar = new Gtk::ProgressBar();
    m_pProgressBar->set_pulse_step(0.10);
    set_progress(0.18);
    prog_vbox->pack_start(*manage(m_pProgressBar));

    m_pStatus_Label = new Gtk::Label();
    m_pStatus_Label->set_use_markup();
    m_pStatus_Label->set_alignment(0.0, 0.5);
    m_pStatus_Label->set_markup(String::ucompose("<i>%1</i>", initial_status));
    prog_vbox->pack_start(*manage(m_pStatus_Label));
  }

  show_all();
}

Progress::~Progress()
{}

std::auto_ptr<Progress> Progress::create(Gtk::Window& parent,
                                         const Glib::ustring& title,
                                         const Glib::ustring& primary,
                                         const Glib::ustring& secondary,
                                         const Glib::ustring& initial_status)
{
  return std::auto_ptr<Progress>(new Progress(parent,
                                              title,
                                              primary,
                                              secondary,
                                              initial_status));
}

void Progress::set_progress(double fraction)
{
  m_pProgressBar->set_fraction(fraction);
}

void Progress::set_primary(const Glib::ustring& text)
{
  m_pPrimary_Label->set_markup(String::ucompose("<b><span size='larger'>%1</span></b>", text));
}

void Progress::set_secondary(const Glib::ustring& text)
{
  m_pSecondary_Label->set_markup(text);
}

void Progress::set_status(const Glib::ustring& text)
{
  m_pStatus_Label->set_markup(String::ucompose("<i>%1</i>", text));
}

} // namespace Dialogs

} // namespace Coaster
