/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_PREFERENCES_H_
#define _COASTER_PREFERENCES_H_

#include "dialogs/client-dialog.h"
#include <memory>

namespace Gtk
{
class Button;
class CheckButton;
class Entry;
class FileChooserButton;
class HBox;
class Label;
class Notebook;
class Table;
class SpinButton;
} // namespace Gtk

namespace Gnome
{
namespace Glade
{
class Xml;
} // namespace Glade
} // namespace Gnome

namespace Nautilus
{
namespace Burn
{
class DriveSelection;
} // namespace Burn
} // namespace Nautilus

namespace Coaster
{

namespace Widgets
{
class ComboDiscSize;
} // namespace Widgets

namespace Dialogs
{

class Preferences : public ClientDialog
{
public:
  Preferences(BaseObjectType* cobject,
              const Glib::RefPtr<Gnome::Glade::Xml>& refXml);
  virtual ~Preferences();

protected:
  // overrides
  //void on_response(int response_id);

  // signal handlers
  void on_help_clicked();
  void on_category_changed(int id);
  void on_sound_enable_changed();

  void on_sound_cb_changed(Gtk::CheckButton* check,
                           Gtk::Widget* button);

private:
  Gtk::Notebook* m_pNotebook;

  // Main widgets
  Gtk::HBox* m_pMain_HBox;

  // General tab widgets
  Gtk::Label* m_pReader_Label;
  Gtk::Label* m_pWriter_Label;

  Gtk::Table* m_pDev_Table;

  Nautilus::Burn::DriveSelection* m_pReader;
  Nautilus::Burn::DriveSelection* m_pWriter;

  // Layouts tab widgets
  Widgets::ComboDiscSize* m_pSize_Combo;

  // Notifications tab widgets
  Gtk::CheckButton* m_pSound_Check;

  Gtk::Table*       m_pSound_Table;

  Gtk::CheckButton*       m_pBurnFin_Check;
  Gtk::FileChooserButton* m_pBurnFin_Button;

  Gtk::CheckButton*       m_pBurnErr_Check;
  Gtk::FileChooserButton* m_pBurnErr_Button;

  // Buttons
  Gtk::Button* m_pHelp;
};

} // namespace Dialogs

} // namespace Coaster

#endif // _COASTER_PREFERENCES_H_
