/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtkmm/treeview.h>
#include "dialogs/preferences.h"

#include "cstr-strings.h"
#include "cstr-intl.h"
#include "instance-manager.h"

#include "widgets/stock-label-button.h"
#include "widgets/combo-disc-size.h"

#include "conf/client.h"
#include "conf/conf-utils.h"

#include "ncbmm/drive-selection.h"

#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>
#include <gtkmm/notebook.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/table.h>
#include <gtkmm/filechooserbutton.h>
#include <gtkmm/stock.h>

#include <libglademm/xml.h>

namespace Coaster
{

namespace Dialogs
{

Preferences::Preferences(BaseObjectType* cobject,
                         const Glib::RefPtr<Gnome::Glade::Xml>& refXml)
: ClientDialog(cobject, refXml),
  m_pNotebook(0), m_pMain_HBox(0), m_pReader_Label(0), m_pWriter_Label(0),
  m_pDev_Table(0), m_pReader(0), m_pWriter(0),
  m_pSize_Combo(0), m_pSound_Check(0), m_pSound_Table(0),
  m_pBurnFin_Check(0), m_pBurnFin_Button(0),
  m_pBurnErr_Check(0), m_pBurnErr_Button(0),
  m_pHelp(0)
{
  set_default_size(100,200);
  refXml->get_widget("prefs_notebook", m_pNotebook);

  // Main widgets
  refXml->get_widget("prefs_main_vbox", m_pMain_HBox);
  /*{
    using namespace Gtk;
    ScrolledWindow* sw = new ScrolledWindow();
    sw->set_policy(POLICY_NEVER, POLICY_AUTOMATIC);
    sw->set_shadow_type(SHADOW_IN);

    m_pCategories = new Widgets::PrefsList();
    sw->add(*manage(m_pCategories));

    m_pMain_HBox->pack_start(*manage(sw), false, false);
  }*/

  // General tab widgets
  refXml->get_widget("prefs_gen_reader_label", m_pReader_Label);
  refXml->get_widget("prefs_gen_writer_label", m_pWriter_Label);
  refXml->get_widget("prefs_gen_dev_table", m_pDev_Table);

  m_pReader = new Nautilus::Burn::DriveSelection();
  m_pReader->property_file_image() = false;
  m_pReader->property_show_recorders_only() = false;
  m_pReader->show_all_children();
  m_pReader_Label->set_mnemonic_widget(*m_pReader);

  m_pDev_Table->attach(*manage(m_pReader), 1, 2, 0, 1, Gtk::FILL, Gtk::FILL);

  m_pWriter = new Nautilus::Burn::DriveSelection();
  m_pWriter->property_file_image() = false;
  m_pWriter->property_show_recorders_only() = false;
  m_pWriter->show_all_children();
  m_pWriter_Label->set_mnemonic_widget(*m_pWriter);

  m_pDev_Table->attach(*manage(m_pWriter), 1, 2, 1, 2, Gtk::FILL, Gtk::FILL);

  // Layouts tab widgets
  refXml->get_widget_derived("prefs_lay_size_combo", m_pSize_Combo);

  // Notifications tab widgets
  refXml->get_widget("prefs_not_sound_check", m_pSound_Check);
  refXml->get_widget("prefs_not_sound_table", m_pSound_Table);
  refXml->get_widget("prefs_not_burnfin_check", m_pBurnFin_Check);
  refXml->get_widget("prefs_not_burnerr_check", m_pBurnErr_Check);

  m_pBurnFin_Button = new Gtk::FileChooserButton(_("Choose sound to play"));
  m_pBurnFin_Button->set_width_chars(10);
  m_pBurnErr_Button = new Gtk::FileChooserButton(_("Choose sound to play"));
  m_pBurnErr_Button->set_width_chars(10);

  m_pSound_Table->attach(*manage(m_pBurnFin_Button), 1, 2, 0, 1, Gtk::FILL, Gtk::FILL);
  m_pSound_Table->attach(*manage(m_pBurnErr_Button), 1, 2, 1, 2, Gtk::FILL, Gtk::FILL);

  //m_pNotebook->set_show_tabs(false);
  //m_pNotebook->set_show_border(false);

  // Buttons
  refXml->get_widget("prefs_help", m_pHelp);
  m_pHelp->signal_clicked().connect(sigc::mem_fun(*this, &Preferences::on_help_clicked));

  // Connect widgets to gconf keys
  m_pConfClient->add_instant("reader", *m_pReader);
  m_pConfClient->add_instant("writer", *m_pWriter);
 
  connect_widget("undo_actions_limit", "prefs_gen_undo_spin");

  m_pConfClient->add_instant("layouts/default_size", *m_pSize_Combo);
  connect_widget("layouts/remove_warn", "prefs_lay_removewarn_check");
  connect_widget("layouts/title_check", "prefs_lay_titlechk_check");

  connect_widget("notifications/sound_enable", "prefs_not_sound_check");
  //connect_widget("notifications/burn_finished", "prefs_not_burnfin_check");
  m_pConfClient->add_instant("notifications/burn_finished", *m_pBurnFin_Check);
  m_pConfClient->add_instant("notifications/burn_finished_file", *m_pBurnFin_Button);
  //connect_widget("notifications/burn_error", "prefs_not_burnerr_check");
  m_pConfClient->add_instant("notifications/burn_error", *m_pBurnErr_Check);
  m_pConfClient->add_instant("notifications/burn_error_file", *m_pBurnErr_Button);

  // Initialize the entries and buttons
  m_pBurnFin_Check->set_sensitive(m_pSound_Check->get_active());
  m_pBurnErr_Check->set_sensitive(m_pSound_Check->get_active());
  
  m_pBurnFin_Button->set_sensitive(m_pBurnFin_Check->get_active());
  m_pBurnErr_Button->set_sensitive(m_pBurnFin_Check->get_active());

  // Connect the signals
  //m_pCategories->signal_category_changed().connect(sigc::mem_fun(*this, &Preferences::on_category_changed));
 
  m_pSound_Check->signal_toggled().connect(sigc::mem_fun(*this, &Preferences::on_sound_enable_changed));

  m_pBurnFin_Check->signal_toggled().connect(sigc::bind(sigc::mem_fun(*this, &Preferences::on_sound_cb_changed), m_pBurnFin_Check, m_pBurnFin_Button));
  m_pBurnErr_Check->signal_toggled().connect(sigc::bind(sigc::mem_fun(*this, &Preferences::on_sound_cb_changed), m_pBurnErr_Check, m_pBurnErr_Button));

  set_default_size(300,400);
  set_position(Gtk::WIN_POS_CENTER);

  load();
  show_all_children();
}

Preferences::~Preferences()
{}

/*void Preferences::on_response(int response_id)
{
  if(response_id == Gtk::RESPONSE_HELP)
    InstanceMgr::instance()->show_help(*this, "preferences");
  else
    hide();
}*/

void Preferences::on_help_clicked()
{
  InstanceMgr::instance()->show_help(*this, "preferences");
}

void Preferences::on_category_changed(int id)
{
  m_pNotebook->set_current_page(id);
}

void Preferences::on_sound_enable_changed()
{
  bool active = m_pSound_Check->get_active();
  m_pBurnFin_Check->set_sensitive(active);
  m_pBurnErr_Check->set_sensitive(active);
}

void Preferences::on_sound_cb_changed(Gtk::CheckButton* check,
                                         Gtk::Widget* button)
{
  button->set_sensitive(check->get_active());
}

} // namespace Dialogs

} // namespace Coaster
