/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_ADD_PROGRESS_H_
#define _COASTER_ADD_PROGRESS_H_

#include <gtkmm/dialog.h>

namespace Gtk
{
class Image;
class Label;
class Button;
} // namespace Gtk

namespace Coaster
{

namespace Dialogs
{

class AddProgress : public Gtk::Dialog
{
public:
  explicit AddProgress(const Gtk::Window& parent,
                       const Glib::ustring& folder);
  virtual ~AddProgress();

  bool show_filename(const Glib::ustring& filename);

protected:
  void init();

  void on_cancel();
  bool on_delete_event(GdkEventAny* event);

  bool on_filename_timeout();

private:
  Gtk::Image*  m_pImage;
  Gtk::Label*  m_pLabel;
  Gtk::Button* m_pCancel;

  Glib::ustring m_filename;
  bool m_bCanceled;
  bool m_bAddTimeout;

  sigc::connection m_timeout_cnxn;
};

} // namespace Dialogs

} // namespace Coaster

#endif // _COASTER_ADD_PROGRESS_H_
