/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "add-progress.h"

#include "cstr-intl.h"
#include "ucompose.h"

#include <gtkmm/label.h>
#include <gtkmm/button.h>
#include <gtkmm/stock.h>

#include <gtkmm/main.h>

namespace Coaster
{

namespace Dialogs
{

AddProgress::AddProgress(const Gtk::Window& window,
                         const Glib::ustring& folder)
: m_pImage(0), m_pLabel(0), m_pCancel(0), m_bCanceled(false)
{
  set_title(String::ucompose(_("Adding %1"), folder));
  set_transient_for(const_cast<Gtk::Window&>(window));

  init();
}

AddProgress::~AddProgress()
{}

void AddProgress::init()
{
  set_default_size(200, 100);
  property_has_separator() = false;
  set_border_width(6);

  Gtk::HBox* pHBox = new Gtk::HBox();
  pHBox->set_border_width(6);
  pHBox->set_spacing(12);
  get_vbox()->pack_start(*manage(pHBox));

  get_vbox()->set_spacing(12);

  m_pLabel = new Gtk::Label();
  m_pLabel->property_ellipsize() = Pango::ELLIPSIZE_MIDDLE;
  pHBox->pack_start(*manage(m_pLabel));

  m_pCancel = add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
  m_pCancel->signal_clicked().connect(sigc::mem_fun(*this, &AddProgress::on_cancel));

  show_all();
}

bool AddProgress::show_filename(const Glib::ustring& filename)
{
  if(m_bCanceled)
    return false;

  show();

  m_pLabel->set_text(filename);

  while(Gtk::Main::events_pending())
    Gtk::Main::iteration();

  return true;
}

void AddProgress::on_cancel()
{
  m_bCanceled = true;
  hide();
}

bool AddProgress::on_delete_event(GdkEventAny* event)
{
  m_bCanceled = true;
  hide();
  return true;
}

} // namespace Dialogs

} // namespace Coaster
