/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "dialogs/about.h"

#include "cstr-intl.h"
#include "ucompose.h"

#include <libgnome/gnome-url.h>

namespace Coaster
{

namespace Dialogs
{

About::About()
{
  set_name(_("Coaster"));
  set_version(PACKAGE_VERSION);

  set_copyright("Copyright \xC2\xA9 2003-2005 The Coaster Development Team");
  set_comments(_("A disc burning program"));

  set_url_hook(sigc::mem_fun(*this, &About::on_link_clicked));
  set_website("http://www.coaster-burn.org");

  //m_vecAuthors.push_back("Coaster UI:");
  m_vecAuthors.push_back("Bryan Forbes <bryan@reigndropsfall.net>");
  /*m_vecAuthors.push_back("");
  m_vecAuthors.push_back("libcoaster:");*/
  m_vecAuthors.push_back("Sean Harshbarger <harshy@dersoldat.org>");
  /*m_vecAuthors.push_back("");
  m_vecAuthors.push_back("libburn:");
  m_vecAuthors.push_back("Derek Foreman <manmower@signalmarketing.com>");
  m_vecAuthors.push_back("Ben Jansens <xor@orodu.net>");*/

  m_vecDocumenters.push_back("Bryan Forbes <bryan@reigndropsfall.net>");

  m_translator = _("translator-credits");
  
  set_authors(m_vecAuthors);
  set_documenters(m_vecDocumenters);
  if(m_translator != "translator-credits")
    set_translator_credits(m_translator);

  Glib::RefPtr<Gdk::Pixbuf> logo =
    Gdk::Pixbuf::create_from_file(COASTER_ICONDIR G_DIR_SEPARATOR_S "coaster.png");
  set_logo(logo);
}

About::~About()
{}

std::auto_ptr<About> About::create()
{
  return std::auto_ptr<About>(new About());
}

void About::on_response(int response_id)
{
  if(response_id == Gtk::RESPONSE_CLOSE)
    hide();
}

void About::on_link_clicked(AboutDialog& dialog, const Glib::ustring& link)
{
  gnome_url_show(link.c_str(), 0);
}

} // namespace Dialogs

} // namespace Coaster
