/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_DATA_VIEW_H_
#define _COASTER_DATA_VIEW_H_

#include "widgets/view-base.h"

#include "cstr-types.h"
#include "sharedptr.h"

#include <libgnomevfsmm/types.h>

namespace Gtk
{
class Action;
class TreeStore;
} // namespace Gtk

namespace Coaster
{

namespace Data
{

class Store;

class View : public Widgets::View_Base
{
public:
  View();
  virtual ~View();

  Glib::ustring get_ui_location() const;

  void disc_size_add(const Gnome::Vfs::FileSize& size);
  void disc_size_remove(const Gnome::Vfs::FileSize& size);

  LayoutType get_layout_type() const;
  Glib::ustring get_contents() const;
  bool load_contents(const Glib::ustring& contents);
  void prepare_for_revert();

protected:
  void init();
  void init_properties();
  
  void create_store();
  void create_layout();
  void create_disc_info();

  // overrides
  void save_to_document();
  void load_from_document();
  void enable_selection_actions(bool enable = true);
  void enable_layout_item_actions(bool enable = true);

  // signal handlers
  void on_disc_size_changed(DiscSizeType size);
  void on_store_modified(bool modified); // override
  void on_layout_selection_changed(int number_selected); // override

  // file menu methods
  void on_file_export_iso();

  // edit menu methods
  void on_edit_cut();
  void on_edit_copy();
  void on_edit_paste();
  void on_edit_clear();
  void on_edit_select_all();

  // search menu methods
  void on_search_find();

  // layout menu methods
  void on_layout_add_files();
  void on_layout_add_folder();
  void on_layout_create_folder();
  void on_layout_remove();
  void on_layout_rename();
  bool set_properties();

  // disc menu methods
  void on_disc_burn(); // override

private:
  Glib::RefPtr<Data::Store> m_refStore;

  // Export Actions
  Glib::RefPtr<Gtk::Action> m_refExport;

  // Selection Actions
  Glib::RefPtr<Gtk::Action> m_refRename;
  Glib::RefPtr<Gtk::Action> m_refRemove;
  Glib::RefPtr<Gtk::Action> m_refCut;
  Glib::RefPtr<Gtk::Action> m_refCopy;

  // Layout Item Actions
  Glib::RefPtr<Gtk::Action> m_refClear;
  Glib::RefPtr<Gtk::Action> m_refSelectAll;
};

} // namespace Data

} // namespace Coaster

#endif // _COASTER_DATA_VIEW_H_
