/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_DATA_UNDO_OPS_H_
#define _COASTER_DATA_UNDO_OPS_H_

#include "undo-op.h"

#include "cstr-types.h"

namespace xmlpp
{
class Element;
} // namespace xmlpp

namespace Coaster
{

namespace Data
{

class Store;

class AddRemOp : public UndoOp
{
public:
  typedef SharedPtr<AddRemOp> AddRemOpPtr;

  static AddRemOpPtr create(const xmlpp::Document* structure,
                            const Glib::ustring& label,
                            const sigc::slot<void,const xmlpp::Element*>& undo_slot,
                            const sigc::slot<void,const xmlpp::Element*>& redo_slot);

  virtual ~AddRemOp();

  void undo();
  void redo();

protected:
  AddRemOp(const xmlpp::Document* structure,
           const Glib::ustring& label,
           const sigc::slot<void,const xmlpp::Element*>& undo_slot,
           const sigc::slot<void,const xmlpp::Element*>& redo_slot);

private:
  sigc::slot<void,const xmlpp::Element*> undo_from_xml;
  sigc::slot<void,const xmlpp::Element*> redo_from_xml;
};

class RenameOp : public UndoOp
{
public:
  typedef SharedPtr<RenameOp> RenameOpPtr;
  
  static RenameOpPtr create(const Glib::ustring& old_path_string,
                            const Glib::ustring& new_path_string,
                            const Glib::ustring& old_value,
                            const Glib::ustring& new_value,
                            const sigc::slot<void,const xmlpp::Element*,bool>& slot_rename);
  virtual ~RenameOp();

  void undo();
  void redo();
  
protected:
  RenameOp(const Glib::ustring& old_path_string,
           const Glib::ustring& new_path_string,
           const Glib::ustring& old_value,
           const Glib::ustring& new_value,
           const sigc::slot<void,const xmlpp::Element*,bool>& slot_rename);

private:
  xmlpp::Element* m_pRenameNode;
  sigc::slot<void,const xmlpp::Element*,bool> rename_from_xml;
};

class MoveOp : public UndoOp
{
public:
  typedef SharedPtr<MoveOp> MoveOpPtr;
  
  static MoveOpPtr create(const xmlpp::Element* old_xml_root,
                          const xmlpp::Element* new_xml_root,
                          const sigc::slot<void,const xmlpp::Element*>& add_slot,
                          const sigc::slot<void,const xmlpp::Element*>& remove_slot);
  virtual ~MoveOp();

  void undo();
  void redo();
  
protected:
  MoveOp(const xmlpp::Element* old_xml_root,
         const xmlpp::Element* new_xml_root,
         const sigc::slot<void,const xmlpp::Element*>& add_slot,
         const sigc::slot<void,const xmlpp::Element*>& remove_slot);

private:
  sigc::slot<void,const xmlpp::Element*> add_back;
  sigc::slot<void,const xmlpp::Element*> remove_from;

  xmlpp::Element* new_node;
  xmlpp::Element* old_node;
};

typedef SharedPtr<AddRemOp>   AddRemOpPtr;
typedef SharedPtr<RenameOp>   RenameOpPtr;
typedef SharedPtr<MoveOp>     MoveOpPtr;

} // namespace Data

} // namespace Coaster

#endif // _COASTER_DATA_UNDO_OPS_H_
