/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_DATA_STORE_H_
#define _COASTER_DATA_STORE_H_

#include "store-base.h"
#include <gtkmm/treestore.h>

#include "data/data-columns.h"
#include "data/data-prop.h"

#include "sharedptr.h"
#include "data/data-row.h"

#include <gtkmm/treemodel.h>
#include <gtkmm/selectiondata.h>

#include <libxml++/document.h>
#include <libxml++/nodes/node.h>

#include <sstream>

namespace Gtk
{
class Widget;
}

namespace Coaster
{

namespace Data
{

class Store : public Gtk::TreeStore,
              public Store_Base
{
public:
  virtual ~Store();

  // slot types
  typedef sigc::slot<void,const Gnome::Vfs::FileSize&> type_slot_size_change;
  typedef sigc::slot<bool,const Gtk::TreePath&,bool> type_slot_expand;
  typedef sigc::slot<void,const Gtk::TreePath&> type_slot_expand_to;
  typedef sigc::slot<bool,const Glib::ustring&> type_slot_report_file;

  static Glib::RefPtr<Store> create(const Columns& cols,
                                    const type_slot_size_change& slot_disc_size_add,
                                    const type_slot_size_change& slot_disc_size_remove,
                                    const type_slot_push_undo& slot_push_undo);
  void set_expand_funcs(const type_slot_expand& slot_expand,
                        const type_slot_expand_to& slot_expand_to);


  bool has_files() const;

  Gnome::Vfs::FileSize get_size() const;
  Gnome::Vfs::FileSize get_size(const Gtk::TreeRow& row) const;
  Gnome::Vfs::FileSize get_size(const type_list_rows& rows) const;
  Gnome::Vfs::FileSize get_size(const Gtk::TreeNodeChildren& children) const;

  Data::Properties get_properties() const;
  void set_properties(const Data::Properties& prop);

  // cut/copy/paste
  void cut();
  void copy();
  void paste();

  // modifying the store
  // from the treeview
  void add_files(const type_list_ustrings& files,
                 bool hidden,
                 const type_slot_report_file& slot_report);
  void add_folder(const Glib::ustring& directory,
                  bool hidden,
                  bool recursive,
                  bool follow_links,
                  const type_slot_report_file& slot_report);
  void create_folder();
  void remove(bool cut = false);
  void clear(bool revert = false);
  void rename(const Glib::ustring& path_text,
              const Glib::ustring& new_text);

  // String methods
  Glib::ustring get_contents(bool internal = false,
                             bool save_parent_path = false) const;
  Glib::ustring get_graft_contents() const;
  void get_graft_contents(std::ostringstream& graft_stream,
                          const xmlpp::Element* parent,
                          const Glib::ustring& prefix = Glib::ustring()) const;
  Glib::ustring get_selected_rows(const Glib::ustring& root_node_name) const;

  bool set_contents(const Glib::ustring& contents);

  bool dnd_copy(const Glib::ustring& xmlstruct,
                Gtk::TreeNodeChildren& children,
                bool same_instance);
                     
  bool dnd_move(const Glib::ustring& xmlstruct,
                Gtk::TreeNodeChildren& children);

protected:
  // XML methods
  xmlpp::Document* to_document(bool internal = false,
                               bool save_parent_path = false) const;
  xmlpp::Document* to_document(const type_list_rows& rows,
                               bool internal = false,
                               bool save_parent_path = false) const;
  xmlpp::Document* to_document(const Gtk::TreeRow& row,
                               bool internal = false,
                               bool save_parent_path = false) const;

  void from_document(const xmlpp::Document* document);
  

  void xml_to_prop(const xmlpp::Element* node);
  void prop_to_xml(xmlpp::Element* node) const;

  void branch_to_xml(const Gtk::TreeNodeChildren& group,
                     xmlpp::Element* parent,
                     bool internal = false,
                     bool save_ppath = false) const;
  void branch_to_xml(const type_list_rows& rows,
                     xmlpp::Element* parent,
                     bool internal = false,
                     bool save_ppath = false) const;

  void move_branch_from_xml(const xmlpp::Element* old_node,
                            Gtk::TreeNodeChildren& children,
                            type_list_rows& rows_added);

  void branch_from_xml(const xmlpp::Element* parent,
                       Gtk::TreeNodeChildren& children);

  // modifying from strings which contain xml structures
  void remove_from_string(const Glib::ustring& string);
  void add_back_from_string(const Glib::ustring& string);
  void paste_from_string(const Glib::ustring& string);

  // modifying from xml structure
  void remove_from_xml(const xmlpp::Element* parent);
  void add_back_from_xml(const xmlpp::Element* parent);
  void add_children_from_xml(const xmlpp::Element* parent,
                             Gtk::TreeNodeChildren& children);
  void rename_from_xml(const xmlpp::Element* node,
                       bool redo);

protected:
  Store(const Columns& cols,
        const type_slot_size_change& slot_disc_size_add,
        const type_slot_size_change& slot_disc_size_remove,
        const type_slot_push_undo& slot_push_undo);

  void search_case(const Glib::ustring& search_string);
  void search_nocase(const Glib::ustring& search_string);
  bool on_search_foreach_case(const Gtk::TreeIter& iter,
                              const Glib::ustring& search_string) const;
  bool on_search_foreach_nocase(const Gtk::TreeIter& iter,
                                const Glib::ustring& search_string) const;

  // Overridden signal handlers
  virtual void on_row_changed(const Gtk::TreePath& path,
                              const Gtk::TreeIter& iter);
  virtual void on_row_deleted(const Gtk::TreePath& path);
  virtual void on_row_inserted(const Gtk::TreePath& path,
                               const Gtk::TreeIter& iter);
  virtual void on_rows_reordered(const Gtk::TreePath& path,
                                 const Gtk::TreeIter& iter,
                                 int* new_order);

  //Overridden virtual methods:
  virtual bool row_drop_possible_vfunc(const Gtk::TreeModel::Path& dest,
                                       const Gtk::SelectionData& selection_data) const;

  // Icon Theme methods
  void on_icon_theme_changed();
  bool icon_theme_changed_foreach(const Gtk::TreeModel::iterator& iter);

  // utility methods
  type_list_rows remove_duplicate_rows() const;
  Gtk::TreeRow  get_new_entity_row();
  Gtk::TreeRow  get_new_entity_row(const Gtk::TreeRow& folder_row);
  bool add_to_folder_from_dir(const Gtk::TreeRow& parent_row,
                              const Glib::ustring& folder,
                              bool hidden,
                              bool recursive,
                              bool follow_links,
                              bool& changed,
                              const type_slot_report_file& slot_report);
  void set_row_attribs(Gtk::TreeRow& row,
                       const RowAttr& row_attribs);
  void elem_from_row(xmlpp::Element* parent,
                     const Gtk::TreeRow& row,
                     bool internal = false,
                     bool save_ppath = false) const;
  void row_from_elem(Gtk::TreeRow& row,
                     const xmlpp::Element* elem);
  xmlpp::Node::NodeList get_child_nodes(const xmlpp::Element* rootNode) const;

private:
  Data::Properties m_Properties;
  Data::Columns m_Columns;

  type_slot_size_change disc_size_add;
  type_slot_size_change disc_size_remove;
  type_slot_expand expand_path;
  type_slot_expand_to expand_to_path;
};

} // namespace Data

} // namespace Coaster

#endif // _COASTER_DATA_STORE_H_
