/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_DATA_LAYOUT_H_
#define _COASTER_DATA_LAYOUT_H_

#include "widgets/layout-base.h"

#include <gtkmm/treestore.h>
#include <gtkmm/treerowreference.h>

#include "data/data-columns.h"

#include <vector>

namespace Gtk
{
class CellRendererText;
} // namespace Gtk

namespace Gnome
{

namespace Vfs
{
class FileInfo;
}// namespace Vfs

namespace Glade
{
class Xml;
}// namespace Glade

}// namespace Gnome

namespace Coaster
{

namespace Widgets
{
class TreeColumnName;
} // namespace Widgets

namespace Data
{

class Store;

class Layout : public Widgets::Layout_Base
{
public:
  explicit Layout(const Glib::RefPtr<Store>& refStore,
                  const sigc::slot<void,guint,guint32>& slot_popup,
                  const sigc::slot<void,const Gnome::Vfs::FileSize&>& slot_disc_size_add,
                  const sigc::slot<void,const Gnome::Vfs::FileSize&>& slot_disc_size_remove);
  virtual ~Layout();

  // used by View
  void rename_selected();

protected:
  // overrides
  void init_columns();
  void init_drag_n_drop();
  
  bool on_button_press_event(GdkEventButton* event);
  bool on_key_press_event(GdkEventKey* event);

  void on_name_edited(const Glib::ustring& path,
                      const Glib::ustring& new_text);
  void on_name_editing_canceled();

  // layout dnd overrides
  void on_drag_begin(const Glib::RefPtr<Gdk::DragContext>& context);
  void on_drag_leave(const Glib::RefPtr<Gdk::DragContext>& context,
                     guint time);
  bool on_drag_drop(const Glib::RefPtr<Gdk::DragContext>& context,
                    int x,
                    int y,
                    guint time);
  void on_drag_data_get(const Glib::RefPtr<Gdk::DragContext>& context,
                        Gtk::SelectionData& selection_data,
                        guint info,
                        guint time);
  void on_drag_data_received(const Glib::RefPtr<Gdk::DragContext>& context,
                             int x,
                             int y,
                             const Gtk::SelectionData& selection_data,
                             guint info,
                             guint time);
  void on_drag_data_delete(const Glib::RefPtr<Gdk::DragContext>& context);
  void on_drag_end(const Glib::RefPtr<Gdk::DragContext>& context);

  void size_cell_data_func(Gtk::CellRenderer* cell,
                           const Gtk::TreeModel::iterator& iter);
  void on_text_edited(const Glib::ustring& path_string,
                      const Glib::ustring& new_text);
  void on_text_editing_canceled();
  void do_nothing();

  void expand_to_created_path(const Gtk::TreePath& path);

  Gtk::TreeNodeChildren get_drop_children(bool exists,
                                          const Gtk::TreePath& path,
                                          const Gtk::TreeViewDropPosition& pos);

private:
  Glib::RefPtr<Data::Store> m_refStore;

  sigc::slot<void,guint,guint32> popup;
  sigc::slot<void,const Gnome::Vfs::FileSize&> disc_size_add;
  sigc::slot<void,const Gnome::Vfs::FileSize&> disc_size_remove;

  // Columns
  Widgets::TreeColumnName* m_colName;
  Column* m_colSize;
  Column* m_colUri;

  // Cell Renderers
  Gtk::CellRendererText* m_NameText_Renderer;
};

} // namespace Data

} // namespace Coaster

#endif // _COASTER_DATA_LAYOUT_H_
