/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_STRINGS_H_
#define _COASTER_STRINGS_H_

#include <glibmm/ustring.h>

namespace Coaster
{

extern const char *const glade_main_filename;
extern const char *const glade_dialogs_filename;
extern const char *const glade_prefs_filename;

extern const Glib::ustring COASTER_GCONFDIR;

extern const Glib::ustring conf_key_reader;
extern const Glib::ustring conf_key_writer;
extern const Glib::ustring conf_key_undo_actions_limit;

extern const Glib::ustring conf_key_lay_default_size;
extern const Glib::ustring conf_key_lay_remove_warn;
extern const Glib::ustring conf_key_lay_title_check;

extern const Glib::ustring conf_key_notif_sound_enable;
extern const Glib::ustring conf_key_notif_burn_finished;
extern const Glib::ustring conf_key_notif_burn_finished_file;
extern const Glib::ustring conf_key_notif_burn_error;
extern const Glib::ustring conf_key_notif_burn_error_file;

extern const Glib::ustring conf_key_search_history;
extern const Glib::ustring conf_key_search_last_search;
extern const Glib::ustring conf_key_search_match_case;

} // namespace Coaster

#endif // _COASTER_STRINGS_H_
