/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cstr-strings.h"

#include <glib/gutils.h>

namespace Coaster
{

const char *const glade_main_filename = COASTER_GLADEDIR G_DIR_SEPARATOR_S "coaster.glade";
const char *const glade_dialogs_filename = COASTER_GLADEDIR G_DIR_SEPARATOR_S "coaster-dialogs.glade";
const char *const glade_prefs_filename = COASTER_GLADEDIR G_DIR_SEPARATOR_S "coaster-preferences.glade";
  
const Glib::ustring COASTER_GCONFDIR = "/apps/coaster";

const Glib::ustring conf_key_reader = COASTER_GCONFDIR + "/reader";
const Glib::ustring conf_key_writer = COASTER_GCONFDIR + "/writer";
const Glib::ustring conf_key_undo_actions_limit = COASTER_GCONFDIR + "/undo_actions_limit";

const Glib::ustring conf_key_lay_default_size = COASTER_GCONFDIR + "/layouts/default_size";
const Glib::ustring conf_key_lay_remove_warn = COASTER_GCONFDIR + "/layouts/remove_warn";
const Glib::ustring conf_key_lay_title_check = COASTER_GCONFDIR + "/layouts/title_check";

const Glib::ustring conf_key_notif_sound_enable = COASTER_GCONFDIR + "/notifications/sound_enable";
const Glib::ustring conf_key_notif_burn_finished = COASTER_GCONFDIR + "/notifications/burn_finished";
const Glib::ustring conf_key_notif_burn_finished_file = COASTER_GCONFDIR + "/notifications/burn_finished_file";
const Glib::ustring conf_key_notif_burn_error = COASTER_GCONFDIR + "/notifications/burn_error";
const Glib::ustring conf_key_notif_burn_error_file = COASTER_GCONFDIR + "/notifications/burn_error_file";

const Glib::ustring conf_key_search_history = COASTER_GCONFDIR + "/search/history";
const Glib::ustring conf_key_search_last_search = COASTER_GCONFDIR + "/search/last_search";
const Glib::ustring conf_key_search_match_case = COASTER_GCONFDIR + "/search/match_case";

} // namespace Coaster
