/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "conf/conf-utils.h"

#include "cstr-strings.h"
#include <gconfmm/client.h>

namespace Coaster
{

namespace Conf
{

bool get_bool(const Glib::ustring& key)
{
  return Gnome::Conf::Client::get_default_client()->get_bool(COASTER_GCONFDIR + "/" + key);
}

bool get_bool_full(const Glib::ustring& key)
{
  return Gnome::Conf::Client::get_default_client()->get_bool(key);
}

Glib::ustring get_string(const Glib::ustring& key)
{
  return Gnome::Conf::Client::get_default_client()->get_string(COASTER_GCONFDIR + "/" + key);
}

int get_int(const Glib::ustring& key)
{
  return Gnome::Conf::Client::get_default_client()->get_int(COASTER_GCONFDIR + "/" + key);
}

} // namespace Conf

} // namespace Coaster
