/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_CLIENT_H_
#define _COASTER_CLIENT_H_

#include <sigc++/trackable.h>

#include "cstr-strings.h"

#include "conf/association.h"

namespace Coaster
{

namespace Conf
{

class Client : public sigc::trackable
{
public:
  typedef std::vector<AssociationPtr> type_vec_widgets;

  Client();
  virtual ~Client();

  void load();
  void save();

  void add(const Glib::ustring& key,
           Gtk::Widget& widget);
  void add_instant(const Glib::ustring& key,
                   Gtk::Widget& widget);

protected:
  void add_implementation(const Glib::ustring& key,
                          Gtk::Widget& widget,
                          bool instant);

  template< class T_Widget >
  void add_association(const Glib::ustring& key,
                       T_Widget& widget,
                       bool instant)
  {
    Glib::ustring full_key = COASTER_GCONFDIR + "/" + key;
    AssociationPtr assoc = Association<T_Widget>::create(full_key, widget, instant);
    m_vecWidgets.push_back(assoc);
    assoc->add(m_refClient);
  }

private:
  Glib::RefPtr<Gnome::Conf::Client> m_refClient;

  type_vec_widgets m_vecWidgets;
};

} // namespace Conf

} // namespace Coaster

#endif // _COASTER_CLIENT_H_
