/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "client.h"

#include "cstr-strings.h"

#include <gtkmm/combobox.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/filechooserbutton.h>

#include <gconfmm/client.h>

#include "ncbmm/drive-selection.h"

namespace Coaster
{

namespace Conf
{

Client::Client()
{
  m_refClient = Gnome::Conf::Client::get_default_client();
  m_refClient->add_dir(COASTER_GCONFDIR);
}

Client::~Client()
{
  m_refClient->remove_dir(COASTER_GCONFDIR);
}

void Client::add(const Glib::ustring& key, Gtk::Widget& widget)
{
  add_implementation(key, widget, false);
}

void Client::add_instant(const Glib::ustring& key, Gtk::Widget& widget)
{
  add_implementation(key, widget, true);
}

void Client::add_implementation(const Glib::ustring& key,
                                Gtk::Widget& widget,
                                bool instant)
{
  if(dynamic_cast<Nautilus::Burn::DriveSelection*>(&widget))
    add_association(key, static_cast<Nautilus::Burn::DriveSelection&>(widget), instant);
  else if(dynamic_cast<Gtk::FileChooserButton*>(&widget))
    add_association(key, static_cast<Gtk::FileChooserButton&>(widget), instant);
  else if(dynamic_cast<Gtk::ComboBox*>(&widget))
    add_association(key, static_cast<Gtk::ComboBox&>(widget), instant);
  else if(dynamic_cast<Gtk::SpinButton*>(&widget))
    add_association(key, static_cast<Gtk::SpinButton&>(widget), instant);
  else if(dynamic_cast<Gtk::Entry*>(&widget))
    add_association(key, static_cast<Gtk::Entry&>(widget), instant);
  else if(dynamic_cast<Gtk::ToggleButton*>(&widget))
    add_association(key, static_cast<Gtk::ToggleButton&>(widget), instant);
}

void Client::load()
{
  for(type_vec_widgets::iterator iter = m_vecWidgets.begin(); iter != m_vecWidgets.end(); ++iter)
    (*iter)->load();
}

void Client::save()
{
  for(type_vec_widgets::iterator iter = m_vecWidgets.begin(); iter != m_vecWidgets.end(); ++iter)
    (*iter)->save();
}

} // namespace Conf

} // namespace Coaster
