/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_CONF_ASSOCIATION_BASE_H_
#define _COASTER_CONF_ASSOCIATION_BASE_H_

#include "sharedptr.h"

#include <gtkmm/widget.h>
#include <gconfmm/entry.h>

namespace Gnome
{
namespace Conf
{
class Client;
} // namespace Conf
} // namespace Gnome

namespace Coaster
{

namespace Conf
{

class Association_Base : public SharedObject
{
public:
  typedef SharedPtr<Association_Base> AssociationPtr;

  void add(const Glib::RefPtr<Gnome::Conf::Client>& conf_client);
  void load();
  void save();

  virtual ~Association_Base();

protected:
  Association_Base(const Glib::ustring& full_key, bool instant);
  Association_Base(const Association_Base& other); // Not implemented


  bool is_instant() const;
  Glib::ustring get_key() const;
  Glib::RefPtr<const Gnome::Conf::Client> get_conf_client() const;
  Glib::RefPtr<Gnome::Conf::Client> get_conf_client();
    
  typedef sigc::slot<void> Callback;
  virtual void connect_widget(Callback on_widget_changed) = 0;
  virtual void load_widget() = 0;
  virtual void save_widget() = 0;

  void on_widget_changed();
  void on_conf_changed(guint cnxn_id, Gnome::Conf::Entry entry);

  Glib::ustring m_key;
  bool m_instant;
  Glib::RefPtr<Gnome::Conf::Client> m_conf_client;

  guint notify_cnxn;

  bool m_bSaving;
  bool m_bLoading;
};

typedef SharedPtr<Association_Base> AssociationPtr;

} // namespace Conf

} // namespace Coaster

#endif // _COASTER_CONF_ASSOCIATION_BASE_H_
