/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "association_base.h"

#include <gconfmm/client.h>

namespace Coaster
{

namespace Conf
{

Association_Base::Association_Base(const Glib::ustring& key, bool instant)
: m_key(key), m_instant(instant), m_bSaving(false), m_bLoading(false)
{
}

Association_Base::~Association_Base()
{
  m_conf_client->notify_remove(notify_cnxn);
}

void Association_Base::add(const Glib::RefPtr<Gnome::Conf::Client>& conf_client)
{
  // Connect signals so that widget changes are saved instantly,
  // and so that widgets are updated immediately if someone else changes
  // the configuration data.

  m_conf_client = conf_client;
  if(is_instant())
  {
    connect_widget(sigc::mem_fun(*this, &Association_Base::on_widget_changed));
    
    // TODO: This notify_add seems to cause segmentation faults when the callback is
    // later invoked. This could be a thread synchronization issue.
    notify_cnxn =
      conf_client->notify_add(get_key(),sigc::mem_fun(*this, &Association_Base::on_conf_changed));
  }
}

void Association_Base::load()
{
  if(get_conf_client())
  {
    m_bLoading = true;
    load_widget();
    m_bLoading = false;
  }
}

void Association_Base::save()
{
  if(get_conf_client())
  {
    m_bSaving = true;
    save_widget();
    m_bSaving = false;
  }
}

void Association_Base::on_widget_changed()
{
  // TODO: Should this be protected by a mutex to avoid overlapping callbacks?
  if(m_bLoading)
  {
    m_bLoading = false;
    return;
  }

  save();
}

void Association_Base::on_conf_changed(guint cnxn_id, Gnome::Conf::Entry entry)
{
  // TODO: Should this be protected by a mutex to avoid overlapping callbacks?
  if(m_bSaving)
  {
    m_bSaving = false;
    return;
  }

  load();
}

bool Association_Base::is_instant() const
{
  return m_instant;
}

Glib::ustring Association_Base::get_key() const
{
  return m_key;
}

// TODO:
// See Scott Meyers "Effective C++" item 21 for reasons why returned
// objects should be const:
// http://www.awprofessional.com/content/images/0201924889/items/item21.html

Glib::RefPtr<const Gnome::Conf::Client> Association_Base::get_conf_client() const
{
  return m_conf_client;
}

Glib::RefPtr<Gnome::Conf::Client> Association_Base::get_conf_client()
{
  return m_conf_client;
}

} // namespace Conf

} // namespace Coaster
