/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_CONF_ASSOCIATION_H_
#define _COASTER_CONF_ASSOCIATION_H_

#include "conf/association_base.h"

namespace Coaster
{

namespace Conf
{

template< class T_Widget >
class Association : public Association_Base
{
public:
  static const AssociationPtr create(const Glib::ustring& full_key,
                                     T_Widget& widget,
                                     bool instant)
  {
    return AssociationPtr( new Association(full_key, widget, instant) );
  }

  virtual ~Association()
  {}

  /** These methods must be implemented explicitly for each
   * specialization of Association<T> to provide appropriate
   * behaviors based on the widget type.
   */
  virtual void connect_widget(Callback on_widget_changed);
  virtual void load_widget();
  virtual void save_widget();

protected:
  Association(const Glib::ustring& full_key, T_Widget& widget, bool instant)
  : Association_Base(full_key,instant), m_widget(widget)
  {
  }

  Association(const Association& other); // Not implemented

private:
  T_Widget& m_widget;
};

} // namespace Conf

} // namespace Coaster

#endif // _COASTER_CONF_ASSOCIATION_H_
