/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_MAKE_ISO_NAUTILUS_H_
#define _COASTER_MAKE_ISO_NAUTILUS_H_

#include "sharedptr.h"

#include "data/data-prop.h"

#include <glibmm/main.h>
#include <glibmm/ustring.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/window.h>

#include <libgnomevfsmm/types.h>

#include <fstream>

namespace Glib
{
class IOChannel;
} // namespace Glib

namespace Gtk
{
class TreeStore;
} // namespace Gtk;

namespace Coaster
{

namespace IO
{

class MakeIso : public SharedObject
{
public:
  MakeIso(std::string& iso_filename,
          const Glib::ustring& graft_file_contents,
          const Data::Properties& dp,
          const Gtk::Window& parent_win);
  virtual ~MakeIso();

  typedef sigc::signal<void,double> type_signal_progress_changed;
  typedef sigc::signal<void,const Glib::ustring&> type_signal_text_changed;
  typedef sigc::signal<bool> type_signal_joliet_error_check;

  type_signal_progress_changed& signal_progress_changed();
  type_signal_text_changed& signal_text_changed();
  type_signal_joliet_error_check& signal_joliet_error_check();

  unsigned long get_iso_filesize(std::string& stderr_data,
                                 int& exit_status,
                                 bool use_joliet);
  bool make_iso();
  void cancel();

protected:
  Gnome::Vfs::FileSize get_free_space_on_tmp();
  std::string get_new_tmp_dir(bool& result);
  
  bool stdout_read(Glib::IOCondition condition);
  bool stderr_read(Glib::IOCondition condition);
private:
  Gtk::Window* m_pParentWindow;
  Glib::ustring m_graft_file_contents;
  Data::Properties m_DataProperties;

  type_signal_progress_changed   m_signal_progress_changed_;
  type_signal_text_changed       m_signal_text_changed_;
  type_signal_joliet_error_check m_signal_joliet_error_check_;

  Glib::RefPtr<Glib::IOChannel> stdout_channel;
  Glib::RefPtr<Glib::IOChannel> stderr_channel;
  Glib::RefPtr<Glib::MainLoop> main_loop;

  std::string graft_filename;
  int fd_graft;
  int pid;

  std::string tmp_dir;

  std::string m_iso_filename;

  bool mkisofs_result;
};

} // namespace IO

} // namespace Coaster

#endif // _COASTER_MAKE_ISO_NAUTILUS_H_
