/* Copyright (C) 2002-2005  The Coaster Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _COASTER_CD_IO_H_
#define _COASTER_CD_IO_H_

#include "data/data-prop.h"

#include "sharedptr.h"
#include "ncbmm/recorder.h"

#include <gtkmm/window.h>
#include <nautilus-burn-drive.h>

#include <deque>

namespace Coaster
{

class InstanceMgr;

namespace Dialogs
{
class Progress;
} // namespace Dialogs

namespace IO
{

class MakeIso;

class BurnDisc : public sigc::trackable
{
public:
  BurnDisc(const Gtk::Window& parent_win,
           const NautilusBurnDrive* rec,
           bool eject_cd,
           int speed,
           bool dummy,
           const Glib::ustring& graft_file_contents,
           const Data::Properties& dp);
  BurnDisc(const Gtk::Window& parent_win,
           const NautilusBurnDrive* rec,
           bool eject_cd,
           int speed,
           bool dummy,
           const std::string& filename);
  ~BurnDisc();

  enum CancelState
  {
    CANCEL_NONE,
	  CANCEL_MAKE_ISO,
	  CANCEL_CD_RECORD
  };

  bool start_burn();

protected:
  void init();

  void on_cancel_clicked();
  void on_progress_changed(double fraction);
  void on_text_changed(const Glib::ustring& text);
  void on_action_changed(Nautilus::Burn::RecorderActions action,
                         Nautilus::Burn::RecorderMedia media);

private:
  std::auto_ptr<Dialogs::Progress> m_pBurnProgress;
  SharedPtr<InstanceMgr> instmgr;
  SharedPtr<MakeIso> mkiso;
  std::string m_filename;

  Glib::RefPtr<Nautilus::Burn::Recorder> m_refRecorder;

  Gtk::Window*       m_parent_win;
  NautilusBurnDrive* m_pDrive;
  bool               m_bEject_CD;
  int                m_dSpeed;
  bool               m_bDummy;

  Glib::ustring    m_graft_file_contents;
  Data::Properties m_DataProperties;

  CancelState cancel;

  Glib::ustring m_progress_text;
  double        m_progress_fraction;
};
       
} // namespace IO

} // namespace Coaster

#endif // _COASTER_CD_IO_H_
