/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.IntBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public abstract class IntBuffer
extends Buffer
implements Comparable {
    protected int[] backing_buffer;
    protected int array_offset = 0;

    public static IntBuffer allocateDirect(int capacity) {
        throw new Error("direct buffers not implemented");
    }

    public static IntBuffer allocate(int capacity) {
        return new IntBufferImpl(capacity, 0, capacity);
    }

    public static final IntBuffer wrap(int[] array, int offset, int length) {
        return new IntBufferImpl(array, offset, length);
    }

    public static final IntBuffer wrap(String a) {
        int len = a.length();
        int[] buffer = new int[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = a.charAt(i);
        }
        return IntBuffer.wrap(buffer, 0, len);
    }

    public static final IntBuffer wrap(int[] array) {
        return IntBuffer.wrap(array, 0, array.length);
    }

    IntBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }

    public IntBuffer get(int[] dst, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public IntBuffer get(int[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public IntBuffer put(IntBuffer src) {
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public IntBuffer put(int[] src, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final IntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final int[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object ob) {
        IntBuffer a = (IntBuffer)ob;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = this.get(i1) - a.get(i2);
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public abstract IntBuffer compact();

    public abstract boolean isDirect();

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();
}

