/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.TextComponent;
import java.awt.peer.TextAreaPeer;
import java.io.Serializable;

public class TextArea
extends TextComponent
implements Serializable {
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private static final long serialVersionUID = 3692302836626095722L;
    private int columns;
    private int rows;
    private int scrollbarVisibility;

    public TextArea() {
        this("", 1, 1, 0);
    }

    public TextArea(String text) {
        this(text, 1, text.length(), 0);
    }

    public TextArea(int rows, int columns) {
        this("", rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns) {
        this(text, rows, columns, 0);
    }

    public TextArea(String text, int rows, int columns, int scrollbarVisibility) {
        super(text);
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (rows < 1 || columns < 0) {
            throw new IllegalArgumentException("Bad row or column value");
        }
        if (scrollbarVisibility != 0 && scrollbarVisibility != 1 && scrollbarVisibility != 2 && scrollbarVisibility != 3) {
            throw new IllegalArgumentException("Bad scrollbar visibility value");
        }
        this.rows = rows;
        this.columns = columns;
        this.scrollbarVisibility = scrollbarVisibility;
    }

    public int getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("Value is less than zero: " + columns);
        }
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public synchronized void setRows(int rows) {
        if (rows < 1) {
            throw new IllegalArgumentException("Value is less than one: " + rows);
        }
        this.rows = rows;
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getRows(), this.getColumns());
    }

    public Dimension getMinimumSize(int rows, int columns) {
        TextAreaPeer tap = (TextAreaPeer)this.getPeer();
        if (tap == null) {
            return null;
        }
        return tap.getMinimumSize(rows, columns);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize(this.getRows(), this.getColumns());
    }

    public Dimension minimumSize(int rows, int columns) {
        return this.getMinimumSize(rows, columns);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getRows(), this.getColumns());
    }

    public Dimension getPreferredSize(int rows, int columns) {
        TextAreaPeer tap = (TextAreaPeer)this.getPeer();
        if (tap == null) {
            return null;
        }
        return tap.getPreferredSize(rows, columns);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize(this.getRows(), this.getColumns());
    }

    public Dimension preferredSize(int columns) {
        return this.getPreferredSize(this.rows, columns);
    }

    public int getScrollbarVisibility() {
        return this.scrollbarVisibility;
    }

    public void addNotify() {
        if (this.getPeer() != null) {
            return;
        }
        this.setPeer(this.getToolkit().createTextArea(this));
    }

    public void append(String str) {
        TextAreaPeer tap = (TextAreaPeer)this.getPeer();
        if (tap == null) {
            return;
        }
        tap.insert(str, tap.getText().length());
    }

    public void appendText(String text) {
        this.append(text);
    }

    public void insert(String text, int pos) {
        TextAreaPeer tap = (TextAreaPeer)this.getPeer();
        if (tap == null) {
            return;
        }
        tap.insert(text, pos);
    }

    public void insertText(String text, int pos) {
        this.insert(text, pos);
    }

    public void replaceRange(String text, int start, int end) {
        TextAreaPeer tap = (TextAreaPeer)this.getPeer();
        if (tap == null) {
            return;
        }
        tap.replaceRange(text, start, end);
    }

    public void replaceText(String text, int start, int end) {
        this.replaceRange(text, start, end);
    }

    protected String paramString() {
        return this.getClass().getName() + "(rows=" + this.getRows() + ",columns=" + this.getColumns() + ",scrollbars=" + this.getScrollbarVisibility() + ")";
    }
}

