/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    private static final long serialVersionUID = -7262534875583282631L;
    private int align;
    private int hgap;
    private int vgap;

    public void addLayoutComponent(String name, Component comp) {
    }

    public int getAlignment() {
        return this.align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int align) {
        this(align, 5, 5);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        this.setVgap(vgap);
        this.setHgap(hgap);
        this.setAlignment(align);
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            try {
                int num = parent.getComponentCount();
                Component[] comps = parent.component;
                Dimension d = parent.getSize();
                Insets ins = parent.getInsets();
                ComponentOrientation orient = parent.getComponentOrientation();
                boolean left_to_right = orient.isLeftToRight();
                int y = ins.top + this.vgap;
                int i = 0;
                while (i < num) {
                    int j;
                    int new_w = ins.left + this.hgap + ins.right;
                    int new_h = 0;
                    boolean found_one = false;
                    for (j = i; j < num && !found_one; ++j) {
                        if (!comps[i].visible) continue;
                        Dimension c = comps[i].getPreferredSize();
                        int next_w = new_w + this.hgap + c.width;
                        if (next_w > d.width && found_one) break;
                        new_w = next_w;
                        new_h = Math.max(new_h, c.height);
                        found_one = true;
                    }
                    int myalign = this.align;
                    if (this.align == 3) {
                        myalign = left_to_right ? 0 : 2;
                    } else if (this.align == 4) {
                        int n = myalign = left_to_right ? 2 : 0;
                    }
                    int x = myalign == 0 ? ins.left + this.hgap : (myalign == 1 ? (d.width - new_w) / 2 : d.width - new_w);
                    for (int k = i; k < j; ++k) {
                        if (!comps[k].visible) continue;
                        Dimension c = comps[k].getPreferredSize();
                        comps[k].setBounds(x, y, c.width, new_h);
                        x += c.width + this.hgap;
                    }
                    i = j;
                    y += new_h + this.vgap;
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    public Dimension minimumLayoutSize(Container cont) {
        return this.getSize(cont, true);
    }

    public Dimension preferredLayoutSize(Container cont) {
        return this.getSize(cont, false);
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void setAlignment(int align) {
        if (align != 0 && align != 2 && align != 1 && align != 3 && align != 4) {
            throw new IllegalArgumentException("invalid alignment: " + align);
        }
        this.align = align;
    }

    public void setHgap(int hgap) {
        if (hgap < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        this.hgap = hgap;
    }

    public void setVgap(int vgap) {
        if (vgap < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.vgap = vgap;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",align=" + this.align + "]";
    }

    private Dimension getSize(Container parent, boolean is_min) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            try {
                int num = parent.getComponentCount();
                Component[] comps = parent.component;
                int w = 0;
                int h = 0;
                for (int i = 0; i < num; ++i) {
                    if (!comps[i].visible) continue;
                    Dimension d = is_min ? comps[i].getMinimumSize() : comps[i].getPreferredSize();
                    w += d.width;
                    h = Math.max(d.height, h);
                }
                Insets ins = parent.getInsets();
                Dimension dimension = new Dimension(w += (num + 1) * this.hgap + ins.left + ins.right, h += 2 * this.vgap + ins.top + ins.bottom);
                Object var10_11 = null;
                return dimension;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                throw throwable;
            }
        }
    }
}

