/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.der.DEREncodingException;
import gnu.java.security.provider.DERReader;
import gnu.java.security.provider.DERWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameters
extends AlgorithmParametersSpi {
    private BigInteger q;
    private BigInteger p;
    private BigInteger g;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Only accepts DSAParameterSpec");
        }
        DSAParameterSpec dsaParamSpec = (DSAParameterSpec)paramSpec;
        this.p = dsaParamSpec.getP();
        this.q = dsaParamSpec.getQ();
        this.q = dsaParamSpec.getG();
    }

    public void engineInit(byte[] params) throws IOException {
        DERReader reader = new DERReader(params);
        try {
            this.p = reader.getBigInteger();
            this.q = reader.getBigInteger();
            this.g = reader.getBigInteger();
        }
        catch (DEREncodingException DERee) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
    }

    public void engineInit(byte[] params, String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
        this.engineInit(params);
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec.isAssignableFrom(DSAParameters.class$("java.security.spec.DSAParameterSpec"))) {
            return new DSAParameterSpec(this.p, this.q, this.g);
        }
        throw new InvalidParameterSpecException("Only accepts DSAParameterSpec");
    }

    public byte[] engineGetEncoded() throws IOException {
        DERWriter writer = new DERWriter();
        return writer.joinarrays(writer.writeBigInteger(this.p), writer.writeBigInteger(this.q), writer.writeBigInteger(this.g));
    }

    public byte[] engineGetEncoded(String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
        return this.engineGetEncoded();
    }

    public String engineToString() {
        String lineSeparator = System.getProperty("line.seperator");
        return "q: " + this.q + lineSeparator + "p: " + this.p + lineSeparator + "g:" + this.g;
    }
}

