/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.der.DEREncodingException;
import java.math.BigInteger;

public class DERReader {
    byte[] source;
    int pos;
    static final int UNIVERSAL = 1;
    static final int APPLICATION = 2;
    static final int CONTEXT_SPECIFIC = 3;
    static final int PRIVATE = 4;

    public DERReader() {
        this.source = null;
        this.pos = 0;
    }

    public DERReader(byte[] source) {
        this.init(source);
    }

    public void init(String source) {
        this.init(source.getBytes());
    }

    public void init(byte[] source) {
        this.source = source;
        this.pos = 0;
    }

    public BigInteger getBigInteger() throws DEREncodingException {
        return new BigInteger(this.getPrimitive());
    }

    private byte[] getPrimitive() throws DEREncodingException {
        byte identifier;
        int tmp = this.pos;
        if ((0x20 & (identifier = this.source[tmp++])) != 0) {
            throw new DEREncodingException();
        }
        int type = this.translateLeadIdentifierByte(identifier);
        int tag = 0x1F & identifier;
        int len = this.source[tmp];
        long length = 0x7F & len;
        if ((0x80 & len) != 0) {
            len &= 0x7F;
            length = 0L;
            for (int i = 0; i < len; ++i) {
                length <<= 8;
                length += this.source[++tmp] >= 0 ? (long)this.source[tmp] : (long)(256 + this.source[tmp]);
            }
            ++tmp;
        } else {
            ++tmp;
        }
        byte[] tmpb = new byte[(int)length];
        System.arraycopy(this.source, tmp, tmpb, 0, (int)length);
        this.pos = tmp + (int)length;
        return tmpb;
    }

    private int translateLeadIdentifierByte(byte b) {
        if ((0x3F & b) == b) {
            return 1;
        }
        if ((0x7F & b) == b) {
            return 2;
        }
        if ((0xBF & b) == b) {
            return 3;
        }
        return 4;
    }

    private int getIdentifier(int tpos) {
        while ((0x80 & this.source[tpos]) != 0) {
            ++tpos;
        }
        return tpos;
    }
}

