/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIObjectOutputStream;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.RemoteException;

public class UnicastConnection
implements Runnable,
ProtocolConstants {
    UnicastConnectionManager manager;
    Socket sock;
    DataInputStream din;
    DataOutputStream dout;
    ObjectInputStream oin;
    ObjectOutputStream oout;
    long reviveTime;
    long expireTime;
    public static final long CONNECTION_TIMEOUT = 10000L;

    private /* synthetic */ void finit$() {
        this.reviveTime = 0L;
        this.expireTime = Long.MAX_VALUE;
    }

    UnicastConnection(UnicastConnectionManager man, Socket sock) {
        this.finit$();
        this.manager = man;
        this.sock = sock;
    }

    void acceptConnection() throws IOException {
        this.din = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        this.dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        int sig = this.din.readInt();
        if (sig != 1246907721) {
            throw new IOException("bad protocol header");
        }
        short ver = this.din.readShort();
        if (ver != 2) {
            throw new IOException("bad protocol version");
        }
        int protocol = this.din.readUnsignedByte();
        if (protocol != 76) {
            this.dout.writeByte(78);
            this.dout.writeUTF(this.manager.serverName);
            this.dout.writeInt(this.manager.serverPort);
            this.dout.flush();
            String rhost = this.din.readUTF();
            int rport = this.din.readInt();
        }
    }

    void makeConnection(int protocol) throws IOException {
        this.din = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        this.dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        this.dout.writeInt(1246907721);
        this.dout.writeShort(2);
        this.dout.writeByte(protocol);
        this.dout.flush();
        if (protocol != 76) {
            int ack = this.din.readUnsignedByte();
            if (ack != 78) {
                throw new RemoteException("Unsupported protocol");
            }
            String dicard_rhost = this.din.readUTF();
            int discard_rport = this.din.readInt();
            this.dout.writeUTF(this.manager.serverName);
            this.dout.writeInt(this.manager.serverPort);
            this.dout.flush();
        }
    }

    DataInputStream getDataInputStream() throws IOException {
        return this.din;
    }

    DataOutputStream getDataOutputStream() throws IOException {
        return this.dout;
    }

    ObjectInputStream getObjectInputStream() throws IOException {
        if (this.oin == null) {
            this.oin = new RMIObjectInputStream(this.din);
        }
        return this.oin;
    }

    ObjectOutputStream getObjectOutputStream() throws IOException {
        if (this.oout == null) {
            this.oout = new RMIObjectOutputStream(this.dout);
        }
        return this.oout;
    }

    void disconnect() {
        try {
            if (this.oout != null) {
                this.oout.close();
            }
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.oin = null;
        this.oout = null;
        this.din = null;
        this.dout = null;
        this.sock = null;
    }

    static boolean isExpired(UnicastConnection conn, long l) {
        return l > conn.expireTime;
    }

    static void resetTime(UnicastConnection conn) {
        long l;
        conn.reviveTime = l = System.currentTimeMillis();
        conn.expireTime = l + (long)10000;
    }

    public void run() {
        while (true) {
            try {
                UnicastServer.dispatch(this);
            }
            catch (Exception e) {
                this.manager.discardConnection(this);
                return;
            }
        }
    }
}

