/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastConnection;
import java.util.ArrayList;
import java.util.Arrays;

class ConnectionRunnerPool {
    private static int size = 5;
    private static int max_size = 10;
    private static ArrayList freelist;
    private static ThreadGroup group;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public static void setSize(int size_) {
        size = size_;
    }

    public static void setMaxSize(int size) {
        max_size = size;
    }

    private static synchronized ConnectionRunner getConnectionRunner() {
        ConnectionRunner a;
        if (freelist.size() == 0) {
            if (size < max_size) {
                a = new ConnectionRunner(group, new Integer(++size).toString());
                a.start();
                freelist.add(a);
            } else {
                while (freelist.size() == 0) {
                    try {
                        ConnectionRunnerPool.class$("gnu.java.rmi.server.ConnectionRunnerPool").wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        a = (ConnectionRunner)freelist.get(0);
        freelist.remove(a);
        return a;
    }

    public static void dispatchConnection(UnicastConnection conn) {
        ConnectionRunner r = ConnectionRunnerPool.getConnectionRunner();
        r.dispatch(conn);
    }

    public static void exit() {
        Thread[] list = new Thread[group.activeCount()];
        group.enumerate(list);
        for (int i = 0; i < list.length; ++i) {
            ((ConnectionRunner)list[i]).exit();
        }
    }

    ConnectionRunnerPool() {
    }

    static {
        group = new ThreadGroup("pool");
        Object[] pools = new ConnectionRunner[size];
        for (int i = 0; i < pools.length; ++i) {
            pools[i] = new ConnectionRunner(group, new Integer(i).toString());
            ((Thread)pools[i]).setContextClassLoader(Thread.currentThread().getContextClassLoader());
            ((Thread)pools[i]).start();
        }
        freelist = new ArrayList(Arrays.asList(pools));
    }

    public static class ConnectionRunner
    extends Thread {
        private UnicastConnection conn;
        private volatile boolean exiting;

        static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
            try {
                return Class.forName(type$);
            }
            catch (ClassNotFoundException write_parm_value$) {
                throw new NoClassDefFoundError(write_parm_value$.getMessage());
            }
        }

        private /* synthetic */ void finit$() {
            this.exiting = false;
        }

        public ConnectionRunner(ThreadGroup group, String id) {
            super(group, id);
            this.finit$();
        }

        public synchronized void run() {
            while (!this.exiting) {
                if (this.conn == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                this.conn.run();
                this.conn = null;
                Class clazz = ConnectionRunner.class$("gnu.java.rmi.server.ConnectionRunnerPool");
                synchronized (clazz) {
                    Object var2_3;
                    block7: {
                        try {
                            freelist.add(this);
                            if (freelist.size() != 1) break block7;
                            ConnectionRunner.class$("gnu.java.rmi.server.ConnectionRunnerPool").notifyAll();
                        }
                        catch (Throwable throwable) {
                            var2_3 = null;
                            throw throwable;
                        }
                    }
                    var2_3 = null;
                }
            }
        }

        public synchronized void dispatch(UnicastConnection conn) {
            this.conn = conn;
            this.notify();
        }

        void exit() {
            this.exiting = true;
            if (this.conn != null) {
                try {
                    this.join(500);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.interrupt();
        }
    }
}

