/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public class SocketChannelImpl
extends SocketChannel {
    Socket sock_object;
    int fd;
    int local_port;
    boolean blocking;
    boolean connected;
    InetSocketAddress sa;

    private /* synthetic */ void finit$() {
        this.blocking = true;
        this.connected = false;
    }

    static native int SocketCreate();

    static native int SocketConnect(int var0, InetAddress var1, int var2);

    static native int SocketBind(int var0, InetAddress var1, int var2);

    static native int SocketListen(int var0, int var1);

    static native int SocketAvailable(int var0);

    static native int SocketClose(int var0);

    static native int SocketRead(int var0, byte[] var1, int var2, int var3);

    static native int SocketWrite(int var0, byte[] var1, int var2, int var3);

    public SocketChannelImpl(SelectorProvider provider) {
        super(provider);
        this.finit$();
        this.fd = SocketChannelImpl.SocketCreate();
        if (this.fd == -1) {
            System.err.println("failed to create socket:" + this.fd);
        }
    }

    public void finalizer() {
        if (this.connected) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void implCloseSelectableChannel() {
        this.connected = false;
        SocketChannelImpl.SocketClose(this.fd);
        this.fd = SocketChannelImpl.SocketCreate();
    }

    protected void implConfigureBlocking(boolean block) {
        if (this.blocking == block) {
            return;
        }
    }

    public boolean connect(SocketAddress remote) throws IOException {
        int port;
        if (this.connected) {
            throw new AlreadyConnectedException();
        }
        this.sa = (InetSocketAddress)remote;
        InetAddress addr = this.sa.getAddress();
        int err = SocketChannelImpl.SocketConnect(this.fd, addr, port = this.sa.getPort());
        if (err < 0) {
            throw new IOException("Connection refused:" + err + ", connect=" + err);
        }
        this.local_port = err;
        this.connected = true;
        return this.blocking;
    }

    public boolean finishConnect() {
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isConnectionPending() {
        return this.blocking;
    }

    public Socket socket() {
        if (this.sock_object != null) {
            // empty if block
        }
        return this.sock_object;
    }

    public int read(ByteBuffer dst) {
        int bytes = 0;
        int len = 1024;
        byte[] b = new byte[len];
        bytes = SocketChannelImpl.SocketRead(this.fd, b, 0, len);
        dst.put(b, 0, bytes);
        if (bytes == 0) {
            return -1;
        }
        return bytes;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) {
        long bytes = 0L;
        for (int i = offset; i < length; ++i) {
            bytes += (long)this.read(dsts[i]);
        }
        return bytes;
    }

    public int write(ByteBuffer src) {
        int bytes = 0;
        int len = src.position();
        if (src instanceof ByteBufferImpl) {
            ByteBufferImpl bi = (ByteBufferImpl)src;
            byte[] b = bi.array();
            bytes = SocketChannelImpl.SocketWrite(this.fd, b, 0, len);
        } else {
            byte[] b = new byte[len];
            src.get(b, 0, len);
            bytes = SocketChannelImpl.SocketWrite(this.fd, b, 0, len);
        }
        return bytes;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) {
        long bytes = 0L;
        for (int i = offset; i < length; ++i) {
            bytes += (long)this.write(srcs[i]);
        }
        return bytes;
    }
}

